/*
* Copyright (c) 2007-2007 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  Holds information common to all media types
*
*/


#include <MCLFItem.h>
#include <pathinfo.h>
#include <liwvariant.h>
#include "mgmresolution.h"

#include "mgmediaitem.h"

// Keys // used by service class and iterator
_LIT8( KMgFileName, "FileName" );
_LIT8( KMgFileExtension, "FileExtension" );
_LIT8( KMgDrive, "Drive" );
_LIT8( KMgFileSize, "FileSize" );
_LIT8( KMgFileDate, "FileDate" );
_LIT8( KMgMediaType, "MediaType" );
_LIT8( KMgMimeType, "MimeType" ); 
_LIT8( KType, "Type");
_LIT8(KXPixels, "XPixels");
_LIT8(KYPixels, "YPixels");

_LIT( EMgPhoneMemory,"C:" );
_LIT( EMgMmc,"E:" );
_LIT( KMediaType, "Media");
_LIT( KImageType, "image");
const TInt KMemoryNameLength = 2;
const TInt KImgLen = 20;

// ---------------------------------------------------------------------------
// CMgMediaItem::FillCommonAttributesL
// Fills the attributes common to all media types
// ---------------------------------------------------------------------------
//

void CMgMediaItem::FillCommonAttributesL(CLiwDefaultMap* aOutputMap, const MCLFItem& aClfItem) 
    {
    
    TPtrC fullName; 
    TPtrC name;
    TPtrC ext;
    TTime time;
    TBuf<KMemoryNameLength> memory;
    TInt32 size;
    TPtrC mimeType;
    TInt32 mediaType;
    TBuf<KImgLen> mediaImage;
    mediaImage.Append( KImageType );
    
    if( KErrNone == aClfItem.GetField( ECLFFieldIdFileNameAndPath, fullName ) )
                                                        
        {
        name.Set( TParsePtrC( fullName ).Name() );
        ext.Set( TParsePtrC( fullName ).Ext() ); 
        if( fullName.Length() > 0 )
            {
            TCharF mmcMemory( PathInfo::MemoryCardRootPath()[0] );
            TCharF itemPath( fullName[0] );
            if( mmcMemory == itemPath )
                { // by default phone memory
                memory = EMgMmc; 
                }
            else
                {
            	memory = EMgPhoneMemory;
                }
            }
        }
        
    aClfItem.GetField( ECLFFieldIdMimeType, mimeType );
    aClfItem.GetField( ECLFFieldIdFileSize, size );
    aClfItem.GetField( ECLFFieldIdFileDate, time );
    aClfItem.GetField( ECLFFieldIdMediaType, mediaType );
     
    // insert all above attribute in map 
    aOutputMap->InsertL( KType, TLiwVariant( KMediaType ) );
    aOutputMap->InsertL( KMgFileName, TLiwVariant( name ) );
    aOutputMap->InsertL( KMgFileExtension, TLiwVariant( ext ) );
    aOutputMap->InsertL( KMgDrive,TLiwVariant( memory ) );
    aOutputMap->InsertL( KMgMimeType,TLiwVariant( mimeType ) );
    aOutputMap->InsertL( KMgMediaType,TLiwVariant( mediaType ) );
    aOutputMap->InsertL( KMgFileDate,TLiwVariant( time ) );
    aOutputMap->InsertL( KMgFileSize,TLiwVariant( size ) );
    
    if ( mediaType == ECLFMediaTypeImage )
        {
        TSize imageRes( 0,0 );
        MResolution* mediaResObj=NULL;
        TInt err =KErrNone;
        TRAP(err,mediaResObj = MediaResolutionFactory::CreateMediaResolutionobjL( mediaImage,fullName ));
        
        if(err == KErrNone){
            CleanupStack::PushL( mediaResObj );
            mediaResObj->GetresolutionL( imageRes );        
            aOutputMap->InsertL( KXPixels,(TInt32)imageRes.iWidth );
            aOutputMap->InsertL( KYPixels,(TInt32)imageRes.iHeight );
            CleanupStack::Pop( mediaResObj );
            delete mediaResObj;
            }
        }         
    }




