/**************************************************************************************************
* Copyright (c) 2010 Sasken Communication Technologies Ltd.
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the "{License}"
* which accompanies  this distribution, and is available
* at the URL "{LicenseUrl}".
*
* Initial Contributors:
* Chandradeep Gandhi, Sasken Communication Technologies Ltd - Initial contribution
*
* Contributors:
* Manasij Roy
* Description:
* Interface spefication for profile of a contact in a social networking site
*
/*************************************************************************************************/

#ifndef SMFPROFILE_H
#define SMFPROFILE_H

#include <QObject>

//From Qt mobility project
#include "qtcontacts.h"
#include "../common/SmfClientGlobal.h"
#include "smfprovider.h"
/**
 * Interface for a contact from a service provider. This class
 * provides basic functionality to allow applications to obtain details of a
 * contact (self or friends) in a social networking service.
 * 
 * All of the functionality described here should be implemented by a service
 * specific plug-in object.
 * Note this class has dependencies on QtMobility project
 */
class SMFCLIENT_EXPORT SmfContact : public QObject
{
  Q_OBJECT

public:
  /** 
   * Constructs SmfContact with base provider info
   * Seeing as this is a plug-in implementation, these will realistically
   * be generated by SMF factory of some kind
   */
  SmfContact(SmfProvider* baseProvider = 0);
  ~SmfContact();


  /**
   * Returns the available sub fields for contacts.
    * The following subtypes are available,-
    * QString userIdInProvider;
    * QtMobility::QContactAddress Adress;
    * QtMobility::QContactAnniversary Anniversary;
    * QtMobility::QContactAvatar  Avatar;
    * QtMobility::QContactBirthday Birthday;
    * QtMobility::QContactEmailAddress EmailAddress;
    * QtMobility::QContactGender Gender;
    * QtMobility::QContactGeolocation Geolocation;
    * QtMobility::QContactGuid Guid;
    * QtMobility::QContactName Name;
    * QtMobility::QContactNickname Nickname;
    * QtMobility::QContactNote Note;
    * QtMobility::QContactOnlineAccount OnlineAccount;
    * QtMobility::QContactOrganization  Organization;
    * QtMobility::QContactPhoneNumber PhoneNumber;
    * QtMobility::QContactTimestamp Timestamp;
    * QtMobility::QContactType Type;
    * QtMobility::QContactUrl  Url;
   */
  virtual QStringList subTypes() const;
  
  //APIs to get base provider info (SmfProvider)
  
  /**
   * Gets the base provider info, note setting the provider is not permitted here
   */
  virtual SmfProvider* getProvider() = 0;
  
public slots:

/**
 * Gets value of the sub field for any contact.
 * @param  subType sub field type 
 * @param info value of the sub field subType
 * @see subTypes()
 * The following subtypes are available,-
 * QString userIdInProvider;
 * QtMobility::QContactAddress Adress;
 * QtMobility::QContactAnniversary Anniversary;
 * QtMobility::QContactAvatar  Avatar;
 * QtMobility::QContactBirthday Birthday;
 * QtMobility::QContactEmailAddress EmailAddress;
 * QtMobility::QContactGender Gender;
 * QtMobility::QContactGeolocation Geolocation;
 * QtMobility::QContactGuid Guid;
 * QtMobility::QContactName Name;
 * QtMobility::QContactNickname Nickname;
 * QtMobility::QContactNote Note;
 * QtMobility::QContactOnlineAccount OnlineAccount;
 * QtMobility::QContactOrganization  Organization;
 * QtMobility::QContactPhoneNumber PhoneNumber;
 * QtMobility::QContactTimestamp Timestamp;
 * QtMobility::QContactType Type;
 * QtMobility::QContactUrl  Url;
 */
  virtual void value(const QString& subType,const QVariant& info); //for any contact
  
  /**
   * Sets the value of the sub field for self contact
   * @param  key sub field type 
   * @param value value to be set for  sub field key
   * @return success of the set
   * @see subTypes()
   */
  virtual bool setValue( const QString & key, const QVariant & value );//for self contact only
	 
  
signals:
/**
 * Emitted when value of self contact changes.
 * @param key the key which is changed
 */
  void detailsUpdated(const QString& key); //for setvalue on self contact
  
private:
  /**
   * Conatact details
   */
  QVariantMap m_details;
	QString m_caption;
	 /**
	 * Externalization
	 */
};
	/**
	 * Externalization
	 */
	QDataStream &operator<<(QDataStream &, const SmfContact&);
	/**
	 * Internalization
	 */
QDataStream &operator>>(QDataStream &, SmfContact&);
SMF_GETSERVICES(SmfContact, "org.symbian.smf.client.contact")
#endif // SMFPROFILE_H
