/*
* Copyright (c) 2010 Sasken Communication Technologies Ltd.
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the "{License}"
* which accompanies  this distribution, and is available
* at the URL "{LicenseUrl}".
*
* Initial Contributors:
* Chandradeep Gandhi, Sasken Communication Technologies Ltd - Initial contribution
*
* Contributors:
*
* Description:
* Interface spefication for posting updates to a social site
*
*/
#ifndef SMFPOSTPROVIDER_H
#define SMFPOSTPROVIDER_H

#include <QObject>
#include <qmobilityglobal.h>
#include <qgeopositioninfo.h>

#include "smfprovider.h"
#include "smfcontact.h"

class SmfProvider; //base-class for service provider
class SmfContact; //class for Contact in a social network



/**
 * Location info
 */
typedef QtMobility::QGeoPositionInfo SmfLocationInfo ;
class SmfPost; //class for information (text, image and url) contained in post in social network
class SmfContactModel;
class SmfStatusData;

//Post lists
typedef QList<SmfPost> SmfPostList;
/**
 * Interface to post scrap/tweet like info.
 * Note that branding information for the particular service implementation
 * is available from getProvider() API. See also:
 * SmfProvider::serviceName(), SmfProvider::serviceIcon(), SmfProvider::description()
 *
 * All of the functionality described here should be implemented by a service
 * specific plug-in object.
 * Interface name for SmfPostProvider is org.symbian.smf.client.contact.posts
 */
class SMFCLIENT_EXPORT SmfPostProvider : public QObject
{
  Q_OBJECT

public:
  /**
   * Constructs SmfPostProvider.
   * @param baseProvider The base provider info
   * Seeing as this is a plug-in implementation, these will realistically
   * be generated by SMF factory of some kind
   */
  SmfPostProvider(SmfProvider* baseProvider = 0);
  ~SmfPostProvider();

  /**
   *  Presence info of the user
   */
enum SmfPresenceInfo
	{
	  ENotSupported,
	  EOnline,
	  EOffline,
	  EBusy,
	  EDoNotDisturb,
	  EAppearOffline,
	  EOther
	};

public:
  /**
   * Gets the posts asynchronously. The signal postsAvailable()with SmfPostList is emitted
   * once the post lists are available
   * @see postsAvailable()
   */
  virtual void getPosts(SmfStatusData statusData) = 0; 
  
  /**
   * Gets the model
   */
  virtual SmfContactModel   model() = 0; 

public slots:

	/**
	 * Updates a post, the success of the post can be checked with signal
	 * updatePostFinished() signal
	 * @param postData data to be posted
	 * @param location location data
	 */
  virtual void updatePost(SmfPost& postData,SmfLocationInfo& location) = 0; // list of contact objects
	/**
	 * Updates a post, the success of the post can be checked with signal
	 * updatePostFinished() signal
	 * @param postData data to be posted
	 * @param location location data
	 */
  virtual void updatePost(SmfPost& postData) = 0; // list of contact objects
  
  /**
   * Updates a post to a particular Smf contact. the success of the post can be checked with signal
   * updatePostFinished() signal.
   * @param postData data to be posted
   * @param contact contact to which the post is to be directed
   * @param location location data
   */
  virtual void updatePostDirected(SmfPost& postData,SmfContact& contact,SmfLocationInfo location) = 0; // list of contact objects
  
  /**
   * Posts appearance info of the user.
   * @param appearence user appearance
   * @see SmfPresenceInfo
   */
  virtual QList<SmfContact> postAppearence(SmfPresenceInfo appearence) = 0; // appear offline, busy, do-not-disturb
  
  //APIs to get/set base provider info (SmfProvider)
  
  /**
   * Gets the base provider info
   */
  virtual SmfProvider* getProvider() = 0;
  
  /**
   * Sets the base provider info
   */
  virtual void setProvider(SmfProvider* provider) = 0;

  Q_SIGNALS:

	/**
	 * Emitted when a request to  getPosts() is finished
	 * Note if number of posts is large, then it can download the list page by page
	 * In that case this signal is emitted multiple times.
	 * @param list list of posts
	 * @param error error string
	 * @param pageNumber Page number
	 */
	void postsAvailable(SmfPostList* list, QString error, int pageNumber=0);
	
	/**
	 * Emitted when update post is finished.
	 * @param success the success of the update
	 */
	void updatePostFinished(bool success);

private:
  SmfProvider* m_baseProvider;
};

SMF_GETSERVICES(SmfPostProvider, "org.symbian.smf.client.contact.posts\0.2")
#endif // SMFPOSTPROVIDER_H
