/**************************************************************************************************
* Copyright (c) 2010 Sasken Communication Technologies Ltd.
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the "{License}"
* which accompanies  this distribution, and is available
* at the URL "{LicenseUrl}".
*
* Initial Contributors:
* Chandradeep Gandhi, Sasken Communication Technologies Ltd - Initial contribution
*
* Contributors:
*
* Description:
* Interface spefication for profile of a contact in a social networking site
*
/*************************************************************************************************/

#ifndef SMFPROFILE_H
#define SMFPROFILE_H

#include <QContactDetail>

class SmfProvider;

/**
 * Interface for a contact from a service provider. This class
 * provides basic functionality to allow applications to obtain details of a
 * contact (self or friends) in a social networking service.
 *
 * All of the functionality described here should be implemented by a service
 * specific plug-in object.
 */
class SmfContact : public QObject
{
  Q_OBJECT;

public:
  // Seeing as this is a plug-in implementation, these will realistically
  // be generated by SMF factory of some kind
  SmfContact(QObject* parent = 0);
  ~SmfContact();


private:
  /*
  QContactAddress                                   Address;
  QContactAnniversary                              Anniversary;
  QContactAvatar                                      Avatar;
  QContactBirthday                                   Birthday;
  QContactEmailAddress                           EmailAddress;
  QContactGender                                     Gender;
  QContactGeolocation                              Geolocation;
  QContactGuid                                        Guid;
  QContactName                                       Name;
  QContactNickname                                 Nickname;
  QContactNote                                        Note;
  QContactOnlineAccount                          OnlineAccount;
  QContactOrganization                             Organization;
  QContactPhoneNumber                           PhoneNumber;
  QContactTimestamp                               Timestamp;
  QContactType                                        Type;
  QContactUrl                                           Url;
  */
  QVariantMap                                           details;

public:
  virtual QStringList subTypes() const;

slots:
  virtual void value(const QString& subType,const QVariant& info); //for any contact
  virtual bool setValue( const QString & key, const QVariant & value );//for self contact only

signals:
  virtual void detailsUpdated(const QString& key); //for setvalue on self contact
};
#endif // SMFPROFILE_H
