/**
* Copyright (c) 2010 Sasken Communication Technologies Ltd.
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the "{License}"
* which accompanies  this distribution, and is available
* at the URL "{LicenseUrl}".
*
* Initial Contributors:
* Chandradeep Gandhi, Sasken Communication Technologies Ltd - Initial contribution
*
* Contributors:
*
* Description:
* Interface spefication for managing associations between various social contacts
*
*/

#ifndef SMFRELATIONMGR_H
#define SMFRELATIONMGR_H

class SmfProvider;
class SmfContact;
class SmfRelationId; //persistent Id of a relation

class SmfRelationItem : public SmfContact
{
	private:
	//SmfProvider* provider;

	public:
	virtual SmfProvider* provider getProvider()=0;
	virtual SmfProvider* provider setProvider(SmfProvider* provider)=0;
};

/**
 * Interface for a base service provider. Other service provider classes o derive from
 * this base class so that each has access to service provider information
 *
 * All of the functionality described here should be implemented by a service
 * specific plug-in object.
 */
class SmfRelationMgr : public QObject
{
  Q_OBJECT;

public:
  // Seeing as this is a plug-in implementation, these will realistically
  // be generated by SMF factory of some kind
  SmfRelationMgr(QObject* parent = 0);
  ~SmfRelationMgr();

public:
  //create a relation with first contact (id optional)
  virtual SmfRelationId create(SmfProvider provider, SmfContact conact, uint id) = 0;
  // assign contact to a relation
  virtual bool associate(SmfRelationId relation, SmfProvider provider, SmfContact conact) = 0;
  //returns first contact in the relation when exists
  virtual SmfContact searchById(SmfRelationId relation)=0;
  //number of contacts in a relation
  virtual uint count(SmfRelationId relation) = 0;

slots:
  virtual QList<SmfRelationItem> get(SmfRelationId relation)=0;//list of contacts and their provider
  virtual QList<SmfRelationId> getAll()=0;//list of all relations

signals:
  //None at the moment
};

#endif // SMFRELATIONMGR_H
