/**
 * Copyright (c) 2010 Sasken Communication Technologies Ltd.
 * All rights reserved.
 * This component and the accompanying materials are made available
 * under the terms of the "Eclipse Public License v1.0" 
 * which accompanies  this distribution, and is available
 * at the URL "http://www.eclipse.org/legal/epl-v10.html"
 *
 * Initial Contributors:
 * Chandradeep Gandhi, Sasken Communication Technologies Ltd - Initial contribution
 *
 * Contributors:
 * Manasij Roy, Nalina Hariharan
 * 
 * Description:
 * The SmfEvent class represents an event
 *
 */

#ifndef SMFPROVIDER_H
#define SMFPROVIDER_H

#include <QObject>
#include <QImage>
#include <QUrl>
#include <QStringList>
#include <QMetaType>

#include "smfclientglobal.h"

/**
 * @ingroup smf_client_group 
 * Interface for a base service provider. Other service provider classes contains 
 * implementation of this base class so that each has access to service provider 
 * information.
 * All of the functionality described here should be implemented by a service
 * specific plug-in object.
 */
//TODO:- put SMFCLIENT_EXPORT
//TODO:- QList<SmfProvider> gives error if its derived from QObject
class SMFCLIENT_EXPORT SmfProvider //: public QObject
{
  //Q_OBJECT

public:
  /**
   *  Seeing as this is a plug-in implementation, these will realistically be generated by SMF factory of some kind
   */
   
  SmfProvider(QObject* parent = 0);
  ~SmfProvider();

public:
  /**
   * Localizable name of the service 
   * @return service name
   */
  QString serviceName() const; 
  
  /**
   * Logo of the service
   * @return logo image of the service
   */
  QImage serviceIcon() const; 
  
  /**
   * Readable service description
   * @return service description
   */
  QString description() const; 
  
  /*
   * Website of the service
   */
  QUrl serviceUrl() const;
  
  /**
   * URL of the application providing this service
   */
  QUrl applicationUrl() const; //
  
  /**
   * service types - list of interfaces that this provider support
   */
  QList<QString> serviceTypes() const;
  
  /////////////////////////////////////////set APIs
  /**
   * Localizable name of the service 
   * 
   */
  void serviceName(QString& name); 
  
  /**
   * Logo of the service
   * 
   */
  void serviceIcon(QImage& image) ; 
  
  /**
   * Readable service description
   * 
   */
  void description(QString& desc) ; 
  
  /*
   * Website of the service
   */
  void serviceUrl(QUrl& url) ;
  
  /**
   * URL of the application providing this service
   */
  void applicationUrl(QUrl& url) ; 
  
  /**
   * service types - list of interfaces that this provider support
   */
 void serviceTypes( QStringList& types);
 //TODO:- making data mems public just for testing, later provide set apis
//private:
public:
  QString m_serviceName;
  QImage m_serviceIcon;
  QString m_description;
  QUrl m_serviceUrl;
  QUrl m_appUrl;
  QStringList m_serviceTypes;
  friend QDataStream &operator<<(QDataStream &, const SmfProvider&);
  friend QDataStream &operator>>(QDataStream &, SmfProvider&);
};
/**
* Externalization
*/
SMFCLIENT_EXPORT QDataStream &operator<<(QDataStream &, const SmfProvider&);
/**
 * Internalization
 */
SMFCLIENT_EXPORT QDataStream &operator>>(QDataStream &, SmfProvider&);

typedef QList<SmfProvider> SmfProviderList;

// Make the class SmfProvider known to QMetaType, so that as to register it.
Q_DECLARE_METATYPE(SmfProvider)
Q_DECLARE_METATYPE(QList<SmfProvider>)

#endif // SMFPROVIDER_H
