// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// mdnsserversession.h
// 
//
/**
@file
@internalTechnology
*/

#ifndef __MDNSSERVERSESSION_H__
#define __MDNSSERVERSESSION_H__

#include <e32base.h>
#include <pnp/pnpparameterbundle.h>
#include <mdns/mdnsparamset.h>
#include <mdns/ccacheentry.h>

//User Include
#include "cmessagehandler.h"
#include "mdnsdebug.h"
class CMdnsServer;


class CMdnsServerSession : public CSession2
	{
public:
	static CMdnsServerSession* NewL(const CMdnsServer& aServer);
	static CMdnsServerSession* NewLC(const CMdnsServer& aServer);
	
	void ServiceL(const RMessage2& aMessage);
	void ServiceError(const RMessage2& aMessage, TInt aError);
	TInt OutStandQueryClientHandle()const;
	void SendResponseL();
	//void HandleNameChangeL();
	void HandleServiceNameConflictL(const RBuf8& aName,TInt aError);
	void ServiceQueryL(const RMessage2& aMessage);
	void PublishL(const RMessage2& aMessage);
	void NewServiceL(const RArray<RBuf8>& aName);
	TInt SessionId();
	~CMdnsServerSession();
	
private:
	CMdnsServerSession(const CMdnsServer& aServer);
	void ConstructL();
	TInt CountResources();
	void RegisterNotifyL(const RMessage2& aMessage);
	void ServerVersionL(const RMessage2& aMessage);
	void StopNotifyL (const RMessage2& aMessage);
	void CleanUp();
	void CreateAnyQueryResponseL(CCacheEntry& aEntry);
private:
	CMdnsServer& iServer;
	RMessage2 iClientQuery;
	RMessage2 iPublishRequest;
	RMessage2 iNotifyMessageRequest;
	RPnPParameterBundle iQueryBundle;
	RPnPParameterBundle iResponseBundle;
	RPnPParameterBundle iPublishBundle;
	RArray<RBuf8>       iRegisterNotifyArray;
	
	//TInt iNextSubsessionId;
	TInt iSessionId;
	TBool iIsNotifyRequested;
	
	TInt iLastTypeSent;
	
	TInt iLastServiceSent;
	/**
	*FLOGGER debug trace member variable.
	*/
	__FLOG_DECLARATION_MEMBER_MUTABLE;
	};

#endif /* __MDNSSERVERSESSION_H__ */
