/*
* Copyright (c) 2008 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/


/**
@file
@internalTechnology
*/

//User Include
#include "shutdowntimer.h"
#include "mdnsserver.h"
__FLOG_STMT(_LIT8(KComponent,"MDNSServer");)

CShutdownTimer* CShutdownTimer::NewL(CMdnsServer& aServer)
	{

	CShutdownTimer* self = CShutdownTimer::NewLC(aServer);
	CleanupStack::Pop(self);
	
	return self;
	}


CShutdownTimer* CShutdownTimer::NewLC(CMdnsServer& aServer)
	{
	
	CShutdownTimer* self = new (ELeave) CShutdownTimer(aServer);
	CleanupStack::PushL(self);
	self->ConstructL();

	return self;
	}
	
void CShutdownTimer::Start()
	{
	TTimeIntervalMicroSeconds32 interval(KShutdownDelay);
	//After(interval);
	After(1000000);
	}
	

void CShutdownTimer::RunL()
	{
	// tell the server to begin the shutdown process
	iServer.BeginShutdownL();
	}
	
TInt CShutdownTimer::RunError(TInt /*aError*/)
	{
	CActiveScheduler::Stop();
	return KErrNone;
	}
	
CShutdownTimer::CShutdownTimer(CMdnsServer& aServer)
	: CTimer(EPriorityStandard), iServer(aServer)
	{
	CActiveScheduler::Add(this);
	}

CShutdownTimer::~CShutdownTimer()
    {
    
    }
