/*
* Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/

#include "downloadicon.h"

#include <QtNetwork>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QMessageBox>

DownloadIcon::DownloadIcon(Ui::MainWindow &aMainUi)
    :MainUi(aMainUi)
    {
    manager = new QNetworkAccessManager(this);
    
    }
DownloadIcon::~DownloadIcon()
    {
    if(manager)
        {
        manager->disconnect();    
        delete manager;
        manager = 0;
        }
    }

void DownloadIcon::ChangePathSlash()
    {
    //filePath contains C:\\Data\\ZeroConf\\name.ico
    //after this method is called it must have
    //c://data//zeroconf//name.ico
    int start = 0;
    while( (start = filePath.indexOf("\\",start))!= -1)
        {
            filePath.remove(start,1);
            filePath.insert(start,"//");
        }
    }


void DownloadIcon::UpdateAvatarItem()
    {
    int count = MainUi.listAvatars->count();
    int index = 0;
    while(index < count)
        {
        QListWidgetItem* item = MainUi.listAvatars->item(index);
        if(contactName.compare(item->text()) == 0)
            {
            QPixmap pm;
            //ChangePathSlash();
            //DisplayMsgBox(filePath);
            
            //if(pm.load(filePath))
            if(pm.load("E://mypic.ico"))
                {
                QIcon icon(pm);
                DisplayMsgBox(filePath);
                item->setIcon(icon);
                }
            break;
            }
        index++;
        }
    
    }


void DownloadIcon::RequestFinished()
    {
    
    DisplayMsgBox(tr("Got Response"));
    
    int error = reply->error();
    if(!error)
        {
        QNetworkReply *reply = ((QNetworkReply *)sender());
        QByteArray data = reply->readAll();
        
        if(data.isEmpty())
            DisplayMsgBox(tr("No Data Reply"));
        
        //QTextStream out(&data);
        //QString content = out.readAll();
        
        //QMessageBox::warning(this, tr("Content"),content,QMessageBox::Ok);
        
        //QFile temp(filePath);
        QFile temp("E:\\mypic.ico");
        temp.open(QIODevice::WriteOnly | QIODevice::Truncate);
        temp.write(data);        
        temp.close();
        UpdateAvatarItem();
        }
    else
        DisplayMsgBox(reply->errorString());
    
    //Delete this object once the response is received.
    delete this;
    
    }


void DownloadIcon::GetIcon(const TDesC8& aContactName, const TDesC8& aUri, const TDesC8& aFileName)
    {
    
    QString quri = QString::fromUtf8((const char*)aUri.Ptr(),aUri.Length()); 
    
    contactName = QString::fromUtf8((const char*)aContactName.Ptr(),aContactName.Length());
    filePath = QString::fromUtf8((const char*)aFileName.Ptr(),aFileName.Length());
    
    //DisplayMsgBox(quri);
    
#ifdef __arm 
    reply = manager->get(QNetworkRequest(quri));
#else
    reply = manager->get(QNetworkRequest(QUrl("http://kiranp747.googlepages.com/FileList.txt")));
#endif

    
    connect(reply, SIGNAL(finished()), this, SLOT(RequestFinished()));

    }

void DownloadIcon::DisplayMsgBox(QString str)
    {
    QMessageBox msgBox;
    msgBox.setText(str);
    msgBox.exec();
    }




