/*
* Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/

#ifndef __ZEROCONFCONSOLE_H__
#define __ZEROCONFCONSOLE_H__

#include <e32base.h>
#include <e32cons.h>
#include <es_sock.h>


#include <mdns/mdnsparamset.h>
#include <pnp/pnpparameterbundle.h>
#include <pnp/rpnpservicediscovery.h>
#include <pnp/rpnpservicepublisher.h>

#include <pnp/mpnpobserver.h>
#include <mdns/dnsconstants.h>



enum TZeroConfClientState
	{
	EStateMenu,
	EStateWaiting
	};

class CZeroconfClient : public CBase
	{
public:
	static CZeroconfClient* NewL(MPnPObserver* iObserver);
	static CZeroconfClient* NewLC(MPnPObserver* iObserver);
		
	void ConnectL();
	
	void GetBTName();

	~CZeroconfClient();
private:
	CZeroconfClient(MPnPObserver* iObserver);
	void ConstructL();
public:	

	void WriteServices();
	void WriteServiceTypes();
	void GetService(const TDesC8& aInstanceName,TDnsType aType);
	void PublishService();
	void SearchService();

	void PublishMyService(const TDesC8& aBaseUrl,const TDesC8& aFileList,const TDesC8& aIconName);\
	void PublishNowPlayingServiceL(TDes& aTitleBuf);
	void UpdateNowPlayingServiceL(TDes& aTitleBuf);
	void PublishCurrentStatusServiceL(const TDesC8& aStatus);
	void UpdateCurrentStatusServiceL(const TDesC8& aStatus);
	
	void UnPublishServices();
	
private:
	
	TZeroConfClientState iState;
	
	//////////////////////////
    RPnPServicePublisher    iServicePublish;
    RPnPServicePublisher    iMusicPublish;
    RPnPServicePublisher    iStatusPublish;
    RPnPServiceDiscovery    iControlPoint;

	//////////////////////////
	
    MPnPObserver* iMdnsObserver;
    RBuf iBTName;
	};

#endif /* __ZEROCONFCONSOLE_H__ */
