/*
* Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/



#include "ccacheentry.h"

EXPORT_C CCacheEntry* CCacheEntry::NewL()
	{
	CCacheEntry* self = CCacheEntry::NewLC();
	CleanupStack::Pop(self);
	return self;
	}

EXPORT_C CCacheEntry* CCacheEntry::NewLC()
	{
	CCacheEntry* self = new (ELeave)CCacheEntry();
	CleanupStack::PushL(self);
	self->ConstructL();
	return self;
	}

void CCacheEntry::ConstructL()
	{	
	
	}

CCacheEntry::CCacheEntry()
	{
	
	}

CCacheEntry::~CCacheEntry()
	{
	delete iAddressRecord;
	delete iServiceRecord;
	delete iPtrRecord;
	delete iTxtRecord;
	}

EXPORT_C void CCacheEntry::SetAddressRecord(CRdTypeA* aAddRecord)
	{
	iAddressRecord = aAddRecord;
	}
	
EXPORT_C void CCacheEntry::SetServiceRecord(CRdTypeSrv* aSrvRecord)
	{
	iServiceRecord = aSrvRecord;
	}
	
EXPORT_C void CCacheEntry::SetPtrRecord(CRdTypePtr* aPtrRecord)
	{
	iPtrRecord = aPtrRecord;
	}

EXPORT_C void CCacheEntry::SetTxtRecord(CRdTypeTxt* aTxtRecord)
	{
	iTxtRecord = aTxtRecord;
	}

EXPORT_C CRdTypeA* CCacheEntry::AddressRecord()const
	{
	return iAddressRecord;
	}

EXPORT_C CRdTypeSrv* CCacheEntry::ServiceRecord()const
	{
	return iServiceRecord;
	}

EXPORT_C CRdTypePtr* CCacheEntry::PtrRecord()const
	{
	return iPtrRecord;
	}

EXPORT_C CRdTypeTxt* CCacheEntry::TxtRecord()const
	{
	return iTxtRecord;
	}

EXPORT_C TBool CCacheEntry::IsAuthoritative()const
	{
	return iAuthoritative;
	}

EXPORT_C void CCacheEntry::SetAuthoritative(TBool aAuthoritative)
	{
	iAuthoritative = aAuthoritative;
	}
	
EXPORT_C void CCacheEntry::SetSessionId(TUint32 aSessionId)
	{
	iSessionId = aSessionId;
	}
	
EXPORT_C TUint32 CCacheEntry::SessionId()const
	{
	return iSessionId;
	}

void CCacheEntry::SetEntryExpired(TBool aEntryExpired)
	{
	iEntryExpired = aEntryExpired;
	}
	
EXPORT_C  TBool CCacheEntry::EntryExpired()const
	{
	return iEntryExpired;
	}

	
