// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// cpnpservicediscovery.h
// 
//

#ifndef __CMDNSPSERVICEDISCOVERYIMPL_H__
#define __CMDNSPSERVICEDISCOVERYIMPL_H__

//System include
#include <es_sock.h>
#include <pnp/cpnpservicediscoverybase.h>

//User include.
#include "cmdnsclient.h"
#include "mdnsdebug.h"

const TInt KUPnPDiscoveryUid = 0x2001DC88 ;

/* Body of RPnPServiceDiscovery class and calls the SubmitRequest and NotifyResults
   of respective classes
   @internalComponent
 */
class CMDnsServiceDiscoveryImpl : public CPnPServiceDiscoveryBase
	{
public:
	static CMDnsServiceDiscoveryImpl* NewL();
	~CMDnsServiceDiscoveryImpl ();

private:
	// From CPnPServiceDiscoveryBase
	TInt Construct( TUint aTierId);
	void Discover ( const RPnPParameterBundle& aServiceInfo );
	void Describe ( const RPnPParameterBundle& aServiceInfo );
	void Subscribe ( const RPnPParameterBundle& aServiceInfo );
	void RegisterNotify ( const RPnPParameterBundle& aServiceInfo );
	void Cancel ( const RPnPParameterBundle& aServiceInfo );
	CControlChannelBase* InitiateControlL ( const TDesC8& aUri );

private:
	CMDnsServiceDiscoveryImpl ();

	void DiscoverL ( const RPnPParameterBundle& aServiceInfo );
	void RegisterNotifyL ( const RPnPParameterBundle& aServiceInfo );
	void SubscribeL ( const RPnPParameterBundle& aServiceInfo );
	void DescribeL ( const RPnPParameterBundle& aServiceInfo );

private:
	RMdns iMdns;
	/**
    FLOGGER debug trace member variable.
    */
    __FLOG_DECLARATION_MEMBER_MUTABLE;
	};

#endif // __CMDNSPSERVICEDISCOVERYIMPL_H__
