/*
* Copyright (c) 2008 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/


#ifndef __MDNSPARAMSET_H__
#define __MDNSPARAMSET_H__

#include <es_sock.h>
#include <pnp/pnpparameterbundle.h>
#include <in_sock.h>


const TInt KMDnsParamsFactoryUid = 0x2000D067;//0x2000D05E;

/**
MDns ParameterSet Family Identifiers.
@publishedPartner
@prototype
*/
enum TMDnsParamSetFamily
	{
	EMDnsDiscoverRequestParamSet = 1,
	EMdnsPtrParamset             = 2,
	EMdnsSrvParamset             = 3,
	EMdnsAddrParamset            = 4,
	EMdnsTxtParamset             = 5,
	EMdnsPublishResponseParamset = 6,
	EMdnsRegisterNotifyParamset  = 7,
	EMdnsPublishParamset         = 8,
	//@internalTechnology
	//@prototype
	};

/**
class TMDnsEvent
MDnsEvent class defines the reason code for an event callback.
@publishedPartner
@prototype
*/
NONSHARABLE_CLASS(TMDnsEvent)
	{
public:
	/** Type of MDns Event. */
	enum TEventType
	{
		/** This signifies that the operation completed successfully. */
		ESuccess,
		/** This is a 'catch-all' for communicating failures. The actual error reason is
			shown in error code. */
		EFail,
		/** This signifies a discovery search timeout */
		EDiscoveryTimeout,
		/** This signifies a subscription request timeout */
		ESubscriptionTimeout
	};

public:
	/** The event status. */
	TInt iStatus;
	/** The error code value. */
	TInt iErrorCode;
	};




/**
The base class for all MDns ParamSet classes.

@internalTechnology
@prototype
*/
NONSHARABLE_CLASS (CMDnsParamSetBase) : public CSubConExtensionParameterSet
	{
	public:		
		inline static CMDnsParamSetBase* NewL ( RParameterFamily& aFamily, TMDnsParamSetFamily aFamilyType );
	protected:
		inline CMDnsParamSetBase ();
	};


// -------------------------------------------------------------------

/**
Parameter set class containing a Uri. All UPnP Request ParamSet classes derive from this class.

@internalTechnology
@prototype
*/
NONSHARABLE_CLASS ( CMDnsQueryRequestParamSet ) : public CMDnsParamSetBase
	{
	protected:
		RBuf8 iInstanceName;
		TInt  iQueryType;
		TInt  iProtocol;
		RBuf8 iServiceType;
	public:
		inline static CMDnsQueryRequestParamSet* NewL( RParameterFamily& aFamily );
		inline void SetInstanceNameL ( const TDesC8& aName );
		inline const TDesC8& InstanceName () const;
		inline void SetQueryTypeL(TInt aQueryType );
		inline TInt QueryType()const;
		inline void SetProtocol(TInt aProtocol);
		inline TInt Protocol()const;
		inline void SetServiceTypeL(const TDesC8& aServiceType);
		inline const TDesC8& ServiceType() const;
	protected:
		inline ~CMDnsQueryRequestParamSet ();
	protected:
		DATA_VTABLE
	};

// ----------------------------------------------------------------------
NONSHARABLE_CLASS (CMDnsPtrParamSet): public CMDnsParamSetBase
	{
	protected:
		RBuf8 iInstanceName;
		RBuf8 iDomainName;
		TInt  iTtl;
	public:
		inline static CMDnsPtrParamSet* NewL(RParameterFamily& aFamily)	;
		inline void SetInstanceNameL(const TDesC8& aName);
		inline const TDesC8& InstanceName()const;
		inline void SetDomainNameL(const TDesC8& aDomainName);
		inline const TDesC8& DomainName() const;
		inline void SetTtlL(TInt aTtl);
		inline TInt Ttl() const;
	protected:
	    inline ~CMDnsPtrParamSet();
	protected:
		DATA_VTABLE	
		
	};
	
//---------------------------------------------------------------------------	
NONSHARABLE_CLASS (CMDnsSrvParamSet): public CMDnsParamSetBase
	{
	protected:
		RBuf8 iDomainName;
		RBuf8 iTarget;
		TUint16 iPrio;
		TUint16 iWeight;
		TUint16 iPort;
		
	public:
		inline static CMDnsSrvParamSet* NewL(RParameterFamily& aFamily)	;
		inline void SetDomainNameL(const TDesC8& aDomainName);
		inline const TDesC8& DomainName() const;
		inline void SetTargetL(const TDesC8& aName);
		inline const TDesC8& Target()const;
		inline void SetPriority(TUint16 aPriority);
		inline TUint16 Priority()const;
		inline void SetWeight(TUint16 aWeight);
		inline TUint16 Weight()const;
		inline void SetPort(TUint16 aPort);
		inline TUint16 Port()const;
	protected:
	    inline ~CMDnsSrvParamSet();
	protected:
		DATA_VTABLE	
		
	};
//------------------------------------------------------------------------------	
NONSHARABLE_CLASS (CMDnsAddrParamSet): public CMDnsParamSetBase
	{
	protected:
		RBuf8 iDomainName;
		TInetAddr iAddr;
		
	public:
		inline static CMDnsAddrParamSet* NewL(RParameterFamily& aFamily)	;
		inline void SetDomainNameL(const TDesC8& aDomainName);
		inline const TDesC8& DomainName() const;
		inline void SetAddress(TInetAddr aAddr);
		inline TInetAddr Address()const;
	protected:
	    inline ~CMDnsAddrParamSet();
	protected:
		DATA_VTABLE	
		
	};
	
//-------------------------------------------------------------------------------
NONSHARABLE_CLASS (CMDnsTxtParamSet): public CMDnsParamSetBase
	{
	protected:
		RBuf8 iDomainName;
		RBuf8 iTxtData;
	private:
	    TInt iCount;
	public:
		inline static CMDnsTxtParamSet* NewL(RParameterFamily& aFamily)	;
		inline void SetDomainNameL(const TDesC8& aDomainName);
		inline const TDesC8& DomainName() const;
		inline void AppendTxtData(TDesC8& aData);
		inline void TxtDataL(RArray<RBuf8>& aTxtData);
	private:
	    inline void TokenizeStringL(RBuf8& aString, RArray<RBuf8>& aList, TChar aSeparator);
	protected:
	    inline ~CMDnsTxtParamSet();
	protected:
		DATA_VTABLE	
		
	};
//--------------------------------------------------------------------------------
NONSHARABLE_CLASS (CMDnsPublishResponseParamSet): public CMDnsParamSetBase
    {
    protected:
        RBuf8 iDomainName;
        TInt  iError;
    public:
        inline static CMDnsPublishResponseParamSet* NewL(RParameterFamily& aFamily) ;
        inline void SetDomainNameL(const TDesC8& aDomainName);
        inline const TDesC8& DomainName() const;
        inline void SetError(TInt aError);
        inline TInt Error()const;
    protected:
        inline ~CMDnsPublishResponseParamSet();
    protected:
        DATA_VTABLE 
        
    };

//--------------------------------------------------------------------------------
NONSHARABLE_CLASS (CMDnsRegisterNotifyParamSet): public CMDnsParamSetBase
    {
    protected:
        RBuf8 iInstanceName;
    
    public :
        inline static CMDnsRegisterNotifyParamSet* NewL(RParameterFamily& aFamily);
        inline void SetInstanceNameL(const TDesC8& aInstanceName);
        inline const TDesC8& InstanceName()const;
    protected:
        inline ~CMDnsRegisterNotifyParamSet();
    protected:
        DATA_VTABLE
    
    };

//--------------------------------------------------------------------------------
NONSHARABLE_CLASS (CMDnsPublishParamSet): public CMDnsParamSetBase
    {
    protected:
        TBool  isPublish;
    public:
        inline static CMDnsPublishParamSet* NewL(RParameterFamily& aFamily) ;
        inline void SetPublishUpdate(TBool aFlag);
        inline TBool PublishUpdate()const;
    protected:
        inline ~CMDnsPublishParamSet();
    protected:
        DATA_VTABLE 
        
    };
#include <mdns/mdnsparamset.inl>

#endif // __MDNSPARAMSET_H__
