/*
* Copyright (c) 2008 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/


CMDnsParamSetBase* CMDnsParamSetBase::NewL ( RParameterFamily& aFamily, TMDnsParamSetFamily aFamilyType )
	{
	//STypeId typeId( KMDnsParamsFactoryUid, aFamilyType );
	STypeId typeId;
	typeId = STypeId::CreateSTypeId( KMDnsParamsFactoryUid, aFamilyType );

	CMDnsParamSetBase* self = static_cast < CMDnsParamSetBase* > ( CSubConParameterSet::NewL( typeId ) );
	TBool containerValue = aFamily.IsNull();
	if(!containerValue)
		{
		CleanupStack::PushL ( self );
		aFamily.AddParameterSetL ( self, RParameterFamily::ERequested );			
		CleanupStack::Pop ( self );
		}
	return self;	
	}
CMDnsParamSetBase::CMDnsParamSetBase ()
	{
	}

// ------------------------------------------
CMDnsQueryRequestParamSet* CMDnsQueryRequestParamSet::NewL ( RParameterFamily& aFamily )
 	{	 
 	return static_cast < CMDnsQueryRequestParamSet* > ( CMDnsParamSetBase::NewL( aFamily, EMDnsDiscoverRequestParamSet ) );
 	}
 	
void CMDnsQueryRequestParamSet::SetInstanceNameL ( const TDesC8& aName )
	{
	iInstanceName.Close ();
	iInstanceName.CreateL(aName);
	}

const TDesC8& CMDnsQueryRequestParamSet::InstanceName () const
	{
	return iInstanceName;
	}

void CMDnsQueryRequestParamSet::SetQueryTypeL(TInt aQueryType)
	{
	iQueryType = aQueryType;
	}

TInt CMDnsQueryRequestParamSet::QueryType()const
	{
	return iQueryType;
	}	

void CMDnsQueryRequestParamSet::SetProtocol(TInt aProtocol)
	{
	iProtocol = aProtocol;
	}
	
TInt CMDnsQueryRequestParamSet::Protocol() const
	{
	return iProtocol;
	}

void CMDnsQueryRequestParamSet::SetServiceTypeL(const TDesC8& aServiceType)
	{
	iServiceType.Close();
	iServiceType.CreateL(aServiceType);
	}	

const TDesC8& CMDnsQueryRequestParamSet::ServiceType()const
	{
	return iServiceType;
	}	
		
CMDnsQueryRequestParamSet::~CMDnsQueryRequestParamSet ()
	{
	iInstanceName.Close ();
	iServiceType.Close ();
	}

// -------------------------------------------------------------------------


CMDnsPtrParamSet* CMDnsPtrParamSet::NewL(RParameterFamily& aFamily)	
	{
	return static_cast < CMDnsPtrParamSet* > ( CMDnsParamSetBase::NewL( aFamily, EMdnsPtrParamset ) );	
	}
	

void CMDnsPtrParamSet::SetInstanceNameL(const TDesC8& aName)
	{
	iInstanceName.Close ();
	iInstanceName.CreateL(aName);	
	}


const TDesC8& CMDnsPtrParamSet::InstanceName()const
	{
	return iInstanceName;	
	}


void CMDnsPtrParamSet::SetDomainNameL(const TDesC8& aDomainName)
	{
	iDomainName.Close ();
	iDomainName.CreateL(aDomainName);	
	}


const TDesC8& CMDnsPtrParamSet::DomainName() const
	{
	return iDomainName;	
	}


CMDnsPtrParamSet::~CMDnsPtrParamSet()
	{
	iInstanceName.Close();
	iDomainName.Close();
	}
	
	
//----------------------------------------------------------------------------------------	
CMDnsSrvParamSet* CMDnsSrvParamSet::NewL(RParameterFamily& aFamily)	
	{
	return static_cast < CMDnsSrvParamSet* > ( CMDnsParamSetBase::NewL( aFamily, EMdnsSrvParamset ) );	
	}
	
void CMDnsSrvParamSet::SetDomainNameL(const TDesC8& aDomainName)
	{
	iDomainName.Close ();
	iDomainName.CreateL(aDomainName);	
	}

const TDesC8& CMDnsSrvParamSet::DomainName() const
	{
	return iDomainName;	
	}
	
void CMDnsSrvParamSet::SetTargetL(const TDesC8& aTarget)
	{
	iTarget.Close ();
	iTarget.CreateL(aTarget);	
	}

const TDesC8& CMDnsSrvParamSet::Target() const
	{
	return iTarget;	
	}	
	
void CMDnsSrvParamSet::SetPriority(TUint16 aPriority)
	{
	iPrio = aPriority;
	}
	
TUint16 CMDnsSrvParamSet::Priority()const
	{
	return iPrio;
	}
	
void CMDnsSrvParamSet::SetWeight(TUint16 aWeight)
	{
	iWeight = aWeight;
	}
	
TUint16 CMDnsSrvParamSet::Weight()const
	{
	return iWeight;
	}
	
	
void CMDnsSrvParamSet::SetPort(TUint16 aPort)
	{
	iPort = aPort;
	}

TUint16 CMDnsSrvParamSet::Port()const
	{
	return iPort;
	}
	
			
CMDnsSrvParamSet::~CMDnsSrvParamSet()
	{
	iTarget.Close();
	iDomainName.Close();
	}	
	
//--------------------------------------------------------------------------------

CMDnsAddrParamSet* CMDnsAddrParamSet::NewL(RParameterFamily& aFamily)	
	{
	return static_cast < CMDnsAddrParamSet* > ( CMDnsParamSetBase::NewL( aFamily, EMdnsAddrParamset ) );	
	}
	
void CMDnsAddrParamSet::SetDomainNameL(const TDesC8& aDomainName)
	{
	iDomainName.Close ();
	iDomainName.CreateL(aDomainName);	
	}

const TDesC8& CMDnsAddrParamSet::DomainName() const
	{
	return iDomainName;	
	}
void CMDnsAddrParamSet::SetAddress(TInetAddr aAddr)
	{
	iAddr = aAddr;
	}

TInetAddr CMDnsAddrParamSet::Address()const
	{
	return iAddr;
	}	

CMDnsAddrParamSet::~CMDnsAddrParamSet()
	{
	iDomainName.Close();
	}	
	
//-----------------------------------------------------------------------------------
CMDnsTxtParamSet* CMDnsTxtParamSet::NewL(RParameterFamily& aFamily)	
	{
	return static_cast < CMDnsTxtParamSet* > ( CMDnsParamSetBase::NewL( aFamily, EMdnsTxtParamset ) );	
	}
void CMDnsTxtParamSet::SetDomainNameL(const TDesC8& aDomainName)
	{
	iDomainName.Close ();
	iDomainName.CreateL(aDomainName);	
	}

const TDesC8& CMDnsTxtParamSet::DomainName() const
	{
	return iDomainName;	
	}

void CMDnsTxtParamSet::AppendTxtData(TDesC8& aData)
	{
	_LIT8(KNewLine,"\n");
	RBuf8 temp;
	temp.Create(iTxtData.Length() + aData.Length() + KNewLine().Length());
	temp.Append(iTxtData);
	temp.Append(aData);
	temp.Append(KNewLine);
	iTxtData.Close();
	iTxtData.Create(temp);
	temp.Close();
	}
void CMDnsTxtParamSet::TxtDataL(RArray<RBuf8>& aTxtArray)
	{
	TokenizeStringL(iTxtData,aTxtArray,'\n');
	}

void CMDnsTxtParamSet::TokenizeStringL(RBuf8& aString, RArray<RBuf8>& aList, TChar aSeparator)
	{
	TLex8 lexer(aString);

	while(!lexer.Eos())
		{
		lexer.SkipSpaceAndMark();

		while(!lexer.Eos() && lexer.Get() != aSeparator)
			{
			}

		if(!lexer.Eos())
			{
			lexer.UnGet(); // Do not include trailing ','
			}
		RBuf8 temp;
		temp.Create(lexer.MarkedToken());
		aList.Append(temp);
		lexer.Inc();
		}
	}
CMDnsTxtParamSet::~CMDnsTxtParamSet()
	{
	iDomainName.Close();
	iTxtData.Close();
	}		

//-----------------------------------------------------------------------------------
CMDnsPublishResponseParamSet* CMDnsPublishResponseParamSet::NewL(RParameterFamily& aFamily)	
	{
	return static_cast < CMDnsPublishResponseParamSet* > ( CMDnsParamSetBase::NewL( aFamily, EMdnsSrvParamset ) );	
	}
void CMDnsPublishResponseParamSet::SetDomainNameL(const TDesC8& aDomainName)
	{
	iDomainName.Close ();
	iDomainName.CreateL(aDomainName);	
	}

const TDesC8& CMDnsPublishResponseParamSet::DomainName() const
	{
	return iDomainName;	
	}

void CMDnsPublishResponseParamSet::SetError(TInt aError)
	{
	iError = aError;
	}
TInt CMDnsPublishResponseParamSet::Error()const
	{
	return iError;
	}

CMDnsPublishResponseParamSet::~CMDnsPublishResponseParamSet()
	{
	iDomainName.Close();
	
	}		
//----------------------------------------------------------------------------------------------------------------------------

CMDnsRegisterNotifyParamSet* CMDnsRegisterNotifyParamSet::NewL(RParameterFamily& aFamily)
	{
	return static_cast < CMDnsRegisterNotifyParamSet* > ( CMDnsParamSetBase::NewL( aFamily, EMdnsRegisterNotifyParamset ) );	
	}

void CMDnsRegisterNotifyParamSet::SetInstanceNameL(const TDesC8& aDomainName)
	{
	iInstanceName.Close ();
	iInstanceName.CreateL(aDomainName);	
	}

const TDesC8& CMDnsRegisterNotifyParamSet::InstanceName() const
	{
	return iInstanceName;	
	}

CMDnsRegisterNotifyParamSet::~CMDnsRegisterNotifyParamSet()
	{
	iInstanceName.Close();
	}	
