// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// ecom_impl.cpp
// 
//

#include <e32base.h>
#include <comms-infras/metabuffer.h>
#include "mdnsparamsextfactory.h"
#include "mdnsparamset.h"


START_ATTRIBUTE_TABLE(CMDnsQueryRequestParamSet, KMDnsParamsFactoryUid, EMDnsDiscoverRequestParamSet)
	REGISTER_ATTRIBUTE(CMDnsQueryRequestParamSet, iInstanceName, TMetaBuf8)
	REGISTER_ATTRIBUTE(CMDnsQueryRequestParamSet, iQueryType, TMetaNumber)
	REGISTER_ATTRIBUTE(CMDnsQueryRequestParamSet, iProtocol, TMetaNumber)
	REGISTER_ATTRIBUTE(CMDnsQueryRequestParamSet, iServiceType, TMetaBuf8)
END_ATTRIBUTE_TABLE()


START_ATTRIBUTE_TABLE(CMDnsPtrParamSet, KMDnsParamsFactoryUid, EMdnsPtrParamset)
	REGISTER_ATTRIBUTE(CMDnsPtrParamSet, iInstanceName, TMetaBuf8)
	REGISTER_ATTRIBUTE(CMDnsPtrParamSet, iDomainName, TMetaBuf8)
	REGISTER_ATTRIBUTE(CMDnsPtrParamSet, iTtl, TMetaNumber)
	END_ATTRIBUTE_TABLE()

START_ATTRIBUTE_TABLE(CMDnsSrvParamSet, KMDnsParamsFactoryUid, EMdnsSrvParamset)
	REGISTER_ATTRIBUTE(CMDnsSrvParamSet, iDomainName, TMetaBuf8)
	REGISTER_ATTRIBUTE(CMDnsSrvParamSet, iTarget, TMetaBuf8)
	REGISTER_ATTRIBUTE(CMDnsSrvParamSet, iPrio, TMetaNumber)
	REGISTER_ATTRIBUTE(CMDnsSrvParamSet, iWeight, TMetaNumber)
	REGISTER_ATTRIBUTE(CMDnsSrvParamSet, iPort, TMetaNumber)
END_ATTRIBUTE_TABLE()

START_ATTRIBUTE_TABLE(CMDnsAddrParamSet, KMDnsParamsFactoryUid, EMdnsAddrParamset)
	REGISTER_ATTRIBUTE(CMDnsAddrParamSet, iDomainName, TMetaBuf8)
	REGISTER_ATTRIBUTE(CMDnsAddrParamSet, iAddr, TMeta<TInetAddr>)
END_ATTRIBUTE_TABLE()

START_ATTRIBUTE_TABLE(CMDnsTxtParamSet, KMDnsParamsFactoryUid, EMdnsTxtParamset)
	REGISTER_ATTRIBUTE(CMDnsTxtParamSet, iDomainName, TMetaBuf8)
	REGISTER_ATTRIBUTE(CMDnsTxtParamSet, iTxtData, TMetaBuf8)
END_ATTRIBUTE_TABLE()

START_ATTRIBUTE_TABLE(CMDnsPublishResponseParamSet, KMDnsParamsFactoryUid, EMdnsPublishResponseParamset)
    REGISTER_ATTRIBUTE(CMDnsPublishResponseParamSet, iDomainName, TMetaBuf8)
    REGISTER_ATTRIBUTE(CMDnsPublishResponseParamSet, iError, TMetaNumber)
END_ATTRIBUTE_TABLE()

START_ATTRIBUTE_TABLE(CMDnsRegisterNotifyParamSet, KMDnsParamsFactoryUid, EMdnsRegisterNotifyParamset)
    REGISTER_ATTRIBUTE(CMDnsRegisterNotifyParamSet, iInstanceName, TMetaBuf8)
END_ATTRIBUTE_TABLE()

START_ATTRIBUTE_TABLE(CMDnsPublishParamSet, KMDnsParamsFactoryUid, EMdnsPublishParamset)
    REGISTER_ATTRIBUTE(CMDnsPublishParamSet, isPublish, TMetaNumber)
END_ATTRIBUTE_TABLE()
CMDnsParamSetBase* CMDnsParamsExtFactory::NewL ( TAny* aConstructionParams )
	{
	const TInt32 familyType = reinterpret_cast<TInt32>(aConstructionParams);
	CMDnsParamSetBase* myMDnsParamBase = NULL;
	switch ( familyType )
		{
		case EMDnsDiscoverRequestParamSet:		
			myMDnsParamBase = new (ELeave) CMDnsQueryRequestParamSet;
		break;
		
		case EMdnsPtrParamset:
			myMDnsParamBase = new (ELeave) CMDnsPtrParamSet;
		break;
		
		case EMdnsSrvParamset :
			myMDnsParamBase = new (ELeave) CMDnsSrvParamSet;
		break;
			
		case EMdnsAddrParamset :
			myMDnsParamBase = new (ELeave) CMDnsAddrParamSet;
		break;
		
		case EMdnsTxtParamset :
		 	myMDnsParamBase = new (ELeave) CMDnsTxtParamSet;
		break;
		
		case EMdnsPublishResponseParamset:
		    myMDnsParamBase = new (ELeave) CMDnsPublishResponseParamSet;
		break;
		
		case EMdnsRegisterNotifyParamset:
		    myMDnsParamBase = new (ELeave) CMDnsRegisterNotifyParamSet;
		break;
		
		case EMdnsPublishParamset:
		myMDnsParamBase = new (ELeave) CMDnsPublishParamSet;
		break;
				
		default:
			ASSERT(0);
		break;
		}
	return myMDnsParamBase;
	}

