/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/


#ifndef __CDNSMESSAGE_H__
#define __CDNSMESSAGE_H__

#include <e32base.h>
#include <mdns/cdnsquestion.h>
#include <mdns/crdtypeptr.h>
#include <mdns/crdtypea.h>
#include <mdns/crdtypesrv.h>
#include <mdns/crdtypetxt.h>
#include <mdns/tdnsheader.h>


//This class represents the complete dns message
class CDnsMessage : public CBase
    {
public:
	~CDnsMessage();
	IMPORT_C static CDnsMessage* NewL(TUint16 aId, TBool aQuery);  
	IMPORT_C void AppendQueryL(const CDnsQuestion* aQuery );
	IMPORT_C void AppendAnswerL( const CDnsResourceData* aAnswer );
	IMPORT_C void AppendAuthorityL( const CDnsResourceData* aAuthority );
	IMPORT_C void AppendAdditionalL(const CDnsResourceData* aAdditional );
	IMPORT_C void SetHeader(const TDnsHeader& aHeader);
	IMPORT_C const RPointerArray<CDnsQuestion>& Queries()const;
    IMPORT_C const RPointerArray<CDnsResourceData>& Answers()const;
	IMPORT_C const RPointerArray<CDnsResourceData>& Authorities()const;
    IMPORT_C const RPointerArray<CDnsResourceData>& Additional()const;
	IMPORT_C const TDnsHeader& Header()const;
	IMPORT_C TUint16 Size()const;	
	
private :
     CDnsMessage(TUint16 aId, TBool aQuery);
     
private:
    TDnsHeader iHeader;
    RPointerArray<CDnsQuestion> iQueries;
	RPointerArray<CDnsResourceData> iAnswers;
	RPointerArray<CDnsResourceData> iAuthorities;
	RPointerArray<CDnsResourceData> iAdditional;
    };
	 
#endif //__CDNSMESSAGE_H__