/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/


#ifndef __DNSCONSTANTS_H__
#define __DNSCONSTANTS_H__

#include <in_sock.h> 

const TInt KDnsPort = 53;
const TInt KMdnsPort = 5353;
const TUint32 KMDnsAddr = INET_ADDR(224, 0, 0, 251);

const TInt KDnsTtl = 60 * 60;               //< default one hour TTL
const TInt KKnownAnswerTtl = 120;
const TInt KQueryWaitInterval = 225;        //<milliseconds between query loops.
const TInt KProbeWaitInterval = 250;        //<milliseconds between probe loops.
const TInt KResponseMinWaitInterval = 20;   //<minimal wait interval for response.
const TInt KResponseMaxWaitInterval = 115;  //<maximal wait interval for response
const TInt KProbeConflictInterval = 1000;   //<milliseconds to wait after conflict.
const TInt KAnnounceWaitInterval = 1000;    //<milliseconds between Announce loops.
const TInt KRecordReaperInterval = 10000;   //<milliseconds between cache cleanups.

const TInt KMaxDnsPacketSize = 9216;        //<max mdns packet size

//Dns Opcodes
const TUint16 KDnsOpcode_QUERY	= 0x00; 	//< Standard Query
const TUint16 KDnsOpcode_IQUERY	= 0x01;	    //< Inverse Query (historical)
const TUint16 KDnsOpcode_STATUS	= 0x02;	    //< Server Status Query
const TUint16 KDnsOpcode_UPDATE = 0x05;     //< Dynamic mDNS


const TInt KResponseBit = 0x8000;
const TInt KPointerBit = 0xC0;
const TInt KPointerOffsetBit = 0x3F;
const TUint16 KFlushBit = 0x8000;
const TUint16 KQueryBit = KFlushBit;

const TUint KMaxLabelLength = 63;
const TUint KMaxDNSNameLength= 256;
const TInt KDnsBufferlength = 1000;

//mDNS RR Types
enum TDnsType
	{
	EDnsType_IGNORE     = 0,	//< This is a hack to stop further processing
	EDnsType_A			= 1,	//< a host address
	EDnsType_NS			= 2,	//< an authoritative name server
	EDnsType_MD			= 3,	//< a mail destination (Obsolete - use MX)
	EDnsType_MF			= 4,	//< a mail forwarder (Obsolete - use MX)
	EDnsType_CNAME		= 5,	//< the canonical name for an alias
	EDnsType_SOA		= 6,	//< marks the start of a zone of authority
	EDnsType_MB			= 7,	//< a mailbox domain name 
	EDnsType_MG			= 8,	//< a mail group member 
	EDnsType_MR			= 9,	//< a mail rename domain name 
	EDnsType_NULL		= 10,	//< a null RR 
	EDnsType_WKS		= 11,	//< a well known service description
	EDnsType_PTR		= 12,	//< a domain name pointer
	EDnsType_HINFO		= 13,	//< host information
	EDnsType_MINFO		= 14,	//< mailbox or mail list information
	EDnsType_MX			= 15,	//< mail exchange
	EDnsType_TXT		= 16,	//< text strings
	EDnsType_AAAA		= 28,	//< single IPv6 address (RFC-1886)
	EDnsType_DNAME		= 29,	//< Non-Terminal DNS Name Redirection (RFC-2672)
	EDnsType_SRV		= 33,	//< Location of Services (RFC-2782)
	EDnsType_NAPTR		= 35,	//< Naming Authority Pointer (RFC-2915)
    EDnsQType_Any       = 255   //< Request for all records
	};


//mDNS Class Types
enum TDnsClass
	{
    EDnsClass_IN = 1,       //< public final static Internet
    EDnsClass_CS = 2,        //< CSNET
    EDnsClass_CH= 3,         //< CHAOS
    EDnsClass_HS = 4,       //< Hesiod
    EDnsClass_NONE = 254,	 //< Used in DNS UPDATE [RFC 2136]
    EDnsClass_ANY = 255    //< Not a DNS class, but a DNS query class, meaning "all classes"
	};


//Flags
enum TFlags
	{
	EFlagReserved = 0x0070,
	EFlagRecursionAvailable = 0x0080,
	EFlagRecurse = 0x0100,
	EFlagTruncated = 0x0200,
	EFlagAuthoritative = 0x0400,
	EFlagOpcode = 0x0F00,
	EFlagQuery = 0x8000,
	EFlagResponseCode = 0x000F		
	};


// Response Codes
enum TDnsRcode
	{
    EDnsRcode_NOERROR		    = 0,
	EDnsRcode_FORMAT_ERROR	    = 1,
	EDnsRcode_SERVER_FAILURE	= 2,
	EDnsRcode_NAME_ERROR		= 3,
	EDnsRcode_NOT_IMPLEMENTED	= 4,
	EDnsRcode_REFUSED			= 5
	};

#endif //__DNSCONSTANTS_H__

