/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/



#include "cdnsmessage.h"


CDnsMessage::CDnsMessage(TUint16 aId, TBool aQuery)
   {
   iHeader.SetId(aId);
   iHeader.SetQuery(aQuery);
   }

EXPORT_C CDnsMessage* CDnsMessage::NewL(TUint16 aId, TBool aQuery)
	{
	return ( new(ELeave)CDnsMessage(aId, aQuery) );
    }

CDnsMessage::~CDnsMessage()
	{
	iQueries.ResetAndDestroy();
	iQueries.Close();
	iAnswers.ResetAndDestroy();
	iAnswers.Close();
	iAuthorities.ResetAndDestroy();
	iAuthorities.Close();
	iAdditional.ResetAndDestroy();
	iAdditional.Close();
    }

EXPORT_C void CDnsMessage::SetHeader(const TDnsHeader& aHeader)
	{
	iHeader = aHeader;
	}

EXPORT_C void CDnsMessage::AppendQueryL(const CDnsQuestion* aQuery)
	{
	iQueries.AppendL(aQuery);
	iHeader.SetQueryCount(iQueries.Count());
	}

EXPORT_C void CDnsMessage::AppendAnswerL(const CDnsResourceData* aAnswer)
	{
    	iAnswers.AppendL(aAnswer);
    	iHeader.SetAnswerCount(iAnswers.Count());
    	}

EXPORT_C void CDnsMessage::AppendAuthorityL(const CDnsResourceData* aAuthority)
	{
	iAuthorities.AppendL(aAuthority);
	iHeader.SetAuthorityNSCount(iAuthorities.Count());
    }

EXPORT_C void CDnsMessage::AppendAdditionalL(const CDnsResourceData* aAdditional)
    {
    iAdditional.AppendL(aAdditional);
    iHeader.SetAdditionalRCount(iAdditional.Count());
    }

EXPORT_C const RPointerArray<CDnsQuestion>& CDnsMessage::Queries()const
	{
	return iQueries;
	}

EXPORT_C const RPointerArray<CDnsResourceData>& CDnsMessage::Answers()const
	{
	return iAnswers;
    }

EXPORT_C const RPointerArray<CDnsResourceData>& CDnsMessage::Authorities()const
	{
	return iAuthorities;
    }

EXPORT_C const RPointerArray<CDnsResourceData>& CDnsMessage::Additional()const
	{
	return iAdditional;
    }

EXPORT_C const TDnsHeader& CDnsMessage::Header()const
	{
	return iHeader;
    }

//Calculates the size of the dns message
EXPORT_C TUint16 CDnsMessage::Size()const
    {
    TUint16 size =0;
    size  += sizeof(iHeader);
   
    TInt i;
   
    for ( i=0; i<iQueries.Count(); i++)	   
	    {
	    CDnsQuestion* ques = iQueries[i];
	    size  += ques->Size();
	    }

	for ( i=0; i<iAnswers.Count(); i++)	   
		{
		CDnsResourceData* rData = iAnswers[i];
		size  += rData->Size();
		}
	   
	for ( i=0; i<iAuthorities.Count(); i++)	   
		{
		CDnsResourceData* rData = iAuthorities[i];
		size  += rData->Size();
	    }
	   
	for ( i=0; i<iAdditional.Count(); i++)	   
		{
		CDnsResourceData* rData = iAdditional[i];
		size  += rData->Size();
		}
	return size ;
	}


