/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/


#include "crdtypetxt.h"


CRdTypeTxt::CRdTypeTxt():CDnsResourceData()
	{
    }

EXPORT_C CRdTypeTxt* CRdTypeTxt::NewL()
	{
	return (new(ELeave)CRdTypeTxt());
    }

EXPORT_C CRdTypeTxt::~CRdTypeTxt()
	{
    for ( TInt i=0 ; i < iTxtData.Count(); i++)
    	{
	    iTxtData[i].Close();
    	}
    iTxtData.Close();
	}


EXPORT_C void CRdTypeTxt::AppendTextDataL( const RBuf8& aTextData )
	{
	iTxtData.AppendL(aTextData);
	}

EXPORT_C const RArray<RBuf8>& CRdTypeTxt::Text()const
	{
	return iTxtData;
    }

EXPORT_C TUint16 CRdTypeTxt::Size()const
	{
	TUint16 count = 0;
	count += iName.Size();
	count += 2; // 2 bytes = descriptor length+ 0 length octet at the end
	count += sizeof(iType);
	count += sizeof(iClass);
	count += sizeof(iTtl);
	count += sizeof(iRdLength);
	for ( TInt i= 0; i<iTxtData.Count(); i++)
		{
		count += iTxtData[i].Size();
		count += 1; // one byte for descriptor length
		}
	return count;
	}


