// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// cqueryhandler.h
// 
//
/**
@file
@internalTechnology
*/



#ifndef __CQUERYHANDLER_H__
#define __CQUERYHANDLER_H__

//User include
#include "cmessagehandler.h"
#include <mdns/cdnsmessage.h>
#include "cbasehandler.h"
#include "mmessagehandler.h"
#include "mdnsdebug.h"
/**
Derived From CBaseHandler
Used to process response packet read from the mdns port
*/
class CQueryHandler : public CBaseHandler,public MMessageHandler
	{
	public :
		static CQueryHandler* NewL(CMessageHandler& aMessageHandler);
	 	~CQueryHandler();
	 	
	 	// Derived from CBaseHandler
	 	void HandleIncomingPacketL(CDnsMessage& aMessage, const TSockAddr& aAddr);
		void ServiceClientQueryL(CDnsMessage* aMessage,TInt aClientHandle);
		void OnPacketSendL(TInt aError);
		void SendQueryL(CDnsMessage* aMessage, MMessageHandler& aObserver);		
	private:
	    CQueryHandler(CMessageHandler& aMessageHandler);
	    void ConstructL();
	    TBool SuppressDuplicateAnswerL(const RPointerArray<CDnsResourceData>& aAnswers,const CDnsResourceData& aResourceData);
	    void HandleAnyQuestionL(CDnsMessage* aPacket,const RPointerArray<CDnsResourceData>& aAnswers,const CCacheEntry& aEntry);
	 	
	 	void ScheduleOutStandingQueryL(TInt aClientHandle , TBool aTriggerNow, TTime aInTime);    
	private	:
		TInt iClientHandle;
		/**
		    *FLOGGER debug trace member variable.
		    */
		    __FLOG_DECLARATION_MEMBER_MUTABLE;
	};

#endif

