/*
* Copyright (c) 2001-2008 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/

#include "cfilelistengine.h"
#include <bautils.h>
#include <e32cmn.h>

#undef _UNICODE
_LIT(KDirSounds,"\\Images\\");
_LIT(KDirPictures,"\\Images\\");
_LIT(KDirVideos,"\\Images\\");

//#define KDirSounds    PathInfo::SoundsPath()   //default audio path on phone
//#define KDirPictures  PathInfo::ImagesPath()    //default images path on phone
//#define KDirVideos    PathInfo::VideosPath()    //default videos path

_LIT(KSlash, "\\");
_LIT8(KCR,"\n");
CFileListEngine::CFileListEngine()
    {
    
    }

CFileListEngine::~CFileListEngine()
    {
    iFileList.Close();
    iDirList.Close();
    iFile.Close();
    iFsSession.Close();
    }

CFileListEngine* CFileListEngine::NewLC()
    {
    CFileListEngine* self = new (ELeave) CFileListEngine();
    CleanupStack::PushL(self);
    self->ConstructL();
    return self;
    }

CFileListEngine* CFileListEngine::NewL()
    {
    CFileListEngine* self = CFileListEngine::NewLC();
    CleanupStack::Pop(); // self;
    return self;
    }

void CFileListEngine::ConstructL()
    {
            // Connect to fileserver
    TInt error = iFsSession.Connect();   

    }


TInt CFileListEngine::SetOutputFileName(const TDesC& aFileName)
    {
    TInt err = iFile.Replace(iFsSession,aFileName,EFileWrite);
    return err;
    }


void CFileListEngine::GetAllMediaContent()
    {
    //list photos
    SetDirectory(EDirPhotos);
    StartFileListL();
    WriteEndTag();
    //list music files
    SetDirectory(EDirMusic);
    StartFileListL();
    WriteEndTag();
    //list videos
    SetDirectory(EDirVideos);
    StartFileListL();
    WriteEndTag();
    }

void CFileListEngine::WriteEndTag()
    {
    switch(iDirectory)
      {
        case EDirPhotos:
            {
            _LIT8(Kphotos,"\n[/photos]\n");
            iFile.Write(Kphotos);
            }
        break;
        case EDirMusic:
            {
            _LIT8(Kmusic,"\n[/music]\n");
            iFile.Write(Kmusic);
            }
            break;
        case EDirVideos:
            {
            _LIT8(Kvideos,"\n[/videos]");
            iFile.Write(Kvideos);
            }
            break;
      }
    }
CFileListEngine::TDirOption CFileListEngine::getDirectory()
    {
    return iDirectory;
    }

void CFileListEngine::StartFileListL()
    {
    iFileList.Reset();
    iDirList.Reset();
    RBuf path1;
    path1.CreateL(KMaxPath);
    path1.Append(_L("C:\\data"));
    //TFileName path1 =  PathInfo::PhoneMemoryRootPath();
    switch(iDirectory)
        {
        case EDirPhotos:
            {
                _LIT8(Kphotos,"[photos]");
                iFile.Write(Kphotos);
                path1.Append(KDirPictures);
            }
            break;
        case EDirMusic:
            {
                _LIT8(Kmusic,"[music]");
                iFile.Write(Kmusic);
                path1.Append(KDirSounds);
            }
            break;
        case EDirVideos:
            {
                _LIT8(Kvideos,"[videos]");
                iFile.Write(Kvideos);
                path1.Append(KDirVideos);
            }
            break;
        }   
        
    iSysDirName = path1;
    TRAPD( err, GetResourceFilesL( path1 ));
    path1.Close();
   
    }

void CFileListEngine::GetResourceFilesL ( RBuf &aBasePath )
    {
    CDir* dirs = 0;
    CDir* files = 0;

    if(! BaflUtils::PathExists(iFsSession, aBasePath))
      {
      return;
      }
    User::LeaveIfError(iFsSession.GetDir(aBasePath,KEntryAttNormal,ESortByName,files, dirs));
    
    CleanupStack::PushL(dirs);
    CleanupStack::PushL(files);
    
    //get files in base path
    for( TInt i=0; i<files->Count(); i++ )
        {
        TFileName temp = aBasePath;
        _LIT(Knull,"");
        temp.Replace(0,iSysDirName.Length(),Knull);
        
        TBufC<KMaxFileName> bufc = (*files)[i].iName;
        TPtr ptr = bufc.Des();        
        
        if(AcceptedExtension(ptr)== KErrNone )
            {
                iFile.Write(_L8("\n"));
                TPtr8 dirpath = temp.Collapse();
                iFile.Write(dirpath);
                TPtr8 ptr8 = ptr.Collapse();
                iFile.Write(ptr8);                
                iFileList.Append( (*files)[i] );
                iDirList.Append( aBasePath );
            }
        }
    //get subfolders
    for( TInt i=0; i<dirs->Count(); i++ )
        {
        // Exclude directories beginning with '_' as they can
        // contain system-generated thumbnails etc.
        if( (*dirs)[i].iName[0] != '_')
          {
          RBuf nextDir;
          nextDir.CreateL(KMaxFileName);
          //TFileName nextDir = aBasePath;
          nextDir.Append( (*dirs)[i].iName );
          nextDir.Append( KSlash );
          GetResourceFilesL( nextDir );
          nextDir.Close();
          }
        }
    
    CleanupStack::PopAndDestroy( 2, dirs );
    
    }

void CFileListEngine::SetDirectory(TDirOption aOption)
    {
    iDirectory = aOption;
    }

TInt CFileListEngine::AcceptedExtension(TPtr aPtr)
    {
    TInt flag = 0;
    switch(iDirectory)
        {
        case EDirPhotos:
           {
           //allowed extensions - .jpg, .gif
           _LIT(Kext1,".jpg");
           _LIT(Kext2,".gif");
           if((aPtr.FindC(Kext1)== KErrNotFound) && (aPtr.FindC(Kext2)== KErrNotFound))
               flag = 0;        
           else
               flag = 1;
           }break;
        case EDirMusic:
           {//allowed extensions -.wav, .mp3
           _LIT(Kext3,".wav");
           _LIT(Kext4,".mp3");
           
           if((aPtr.FindC(Kext3)== KErrNotFound) && (aPtr.FindC(Kext4)== KErrNotFound))
                flag = 0;        
           else
                flag = 1;
           }
            break;
        case EDirVideos:
           {//allowed extensions - .mp4
           _LIT(Kext5,".mp4");
           _LIT(Kext6,".avi");
           if((aPtr.FindC(Kext5)== KErrNotFound) && (aPtr.FindC(Kext6)== KErrNotFound))
               flag = 0;
           else flag=1;
           }
           break;
        }
      if(flag == 1)
          return KErrNone;
      else
          return KErrNotFound;
    }


