/*
* Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/

#ifndef CCACHEENTRY_H_
#define CCACHEENTRY_H_

#include <mdns/crdtypea.h>
#include <mdns/crdtypetxt.h>
#include <mdns/crdtypesrv.h>
#include <mdns/crdtypeptr.h>


class CCacheEntry : public CBase
	{
	public:

	IMPORT_C static CCacheEntry* NewL();
	IMPORT_C static CCacheEntry* NewLC();

	IMPORT_C void SetAddressRecord(CRdTypeA* aAddRecord);
	IMPORT_C void SetServiceRecord(CRdTypeSrv* aSrvRecord);
	IMPORT_C void SetPtrRecord(CRdTypePtr* aPtrRecord);
	IMPORT_C void SetTxtRecord(CRdTypeTxt* aTxtRecord);
	
	IMPORT_C CRdTypeA* AddressRecord()const;
	IMPORT_C CRdTypeSrv* ServiceRecord()const;
	IMPORT_C CRdTypePtr* PtrRecord()const;
	IMPORT_C CRdTypeTxt* TxtRecord()const;

	IMPORT_C void SetAuthoritative(TBool aAuthoritative);
	IMPORT_C TBool IsAuthoritative()const;
	
	IMPORT_C void SetSessionId(TUint32 aSessionId);
	IMPORT_C TUint32 SessionId()const;
	
	void SetEntryExpired(TBool aExpired);
	IMPORT_C TBool EntryExpired()const;
	
	~CCacheEntry();
	
	private:

	void ConstructL();
	CCacheEntry();

	private:

	CRdTypeA* iAddressRecord;
	CRdTypeSrv* iServiceRecord;
	CRdTypePtr* iPtrRecord;
	CRdTypeTxt* iTxtRecord;

	TBool iAuthoritative;
	TUint32	iSessionId;
	
	TBool iEntryExpired;

	};
	
#endif /*CCACHEENTRY_H_*/
