// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// cbasehandler.h
// 
//
/**
@file
@internalTechnology
*/

#ifndef __CBASEHANDLER_H__
#define __CBASEHANDLER_H__
//System include 
#include <mdns/cdnsmessage.h>

//User include
#include "cmessagehandler.h"
#include "mdnsdebug.h"

class COutStandingQuery : public CBase
	{
	public :
		static COutStandingQuery* NewL(CDnsMessage* aDnsMessage,TInt aTransactionId,TTime aTime, TSockAddr aAddr);
		~COutStandingQuery();
		 TTime GetAddTime()const;
		TInt TransactionId()const ;
		TSockAddr SocketAddress()const;
		CDnsMessage& DnsMessage()const; 
		TInt ClientHandle()const;
		void SetClientHandle(TInt aHandle);
	private:
		void ConstructL();
		COutStandingQuery(CDnsMessage* aDnsMessage,TInt aTransactionId,TTime aTime, TSockAddr aAddr);
	
	
	private:
	 	TInt iTransactionID;
	 	TTime iReviewTime;
	 	TSockAddr iSockAddress;
	 	CDnsMessage* iDnsMessage;
	 	TInt iClientHandle;
	 	/**
	 	    *FLOGGER debug trace member variable.
	 	    */
	 	    __FLOG_DECLARATION_MEMBER_MUTABLE;
	};

/**
This is a Baseclass to handle common functionality to both the response and query handler
this contains a reference to messagehandler which the derived class can make use of using 
the MessageHandler() api

A reference to cache entry to be passed in order to build a cache wrapper as cache requires
all the records to be present in the CacheEntry variable.

Seperate functions are provide to handle address,pointer,text and srv records as , same can 
be used by both query and response handler.
 
*/
class CBaseHandler : public CTimer
	{
	public :
	 	static CBaseHandler* NewL(CMessageHandler& aMessageHandler);
	 	virtual ~CBaseHandler();
	 	
	 	//From CTimer
	 	void RunL();
	 	void DoCancel();
	 	
	 	virtual void HandleIncomingPacketL(CDnsMessage& aMessage, const TSockAddr& aAddr);
	 	 	
	protected:
	   	CBaseHandler(CMessageHandler& aMessageHandler);
	   	void ConstructL();
	   	CMessageHandler& MessageHandler()const;
	   
	protected:
		RPointerArray<COutStandingQuery> iOutStandingQueryArray;
		TBool IsLastTruncated;    	
	 		 		
	private:
		CMessageHandler& iMessageHandler; 
		/**
		    *FLOGGER debug trace member variable.
		    */
		    __FLOG_DECLARATION_MEMBER_MUTABLE; 
	};

#endif
