// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// cinternalmessagequeue.h
// 
//

#ifndef CINTERNALMESSAGEQUEUE_H_
#define CINTERNALMESSAGEQUEUE_H_

//System Include
#include <e32base.h>
#include "mdnsdebug.h"
class CMdnsServer;

//Message type server handles as of now.
enum TMessageType
    {
    EQueryMessage,
    EPublishMessage,
    ERegisterMessage
    };
/*
 * CInternalMessageQueue class is used to keep a refernce of all the services 
 * requested by the client to the server.
 * There are two cases where this is used.
 * case1:
 *    When the server is probing the hostname and it recieves a query or publish request.
 * case2:
 *    When the server  is adveritsing a packet and it reiceves one more request for advertizement.
 *    
 *    
 */

class CInternalMessageQueue : public CBase
    {
    public:
        static CInternalMessageQueue* NewL(CMdnsServer& aServer);
        ~CInternalMessageQueue();
        void StartProcessing();
        TInt Count();
        void AppendMessageL(TMessageType aType, const RMessage2& aMessage,TInt aSessionId );
    private:
        class TMessageObject
            {
            private:
                TMessageType iType;
                TInt         iSessionId;
                RMessage2 iMessage;
            public:
                inline TMessageObject(TMessageType aType , const RMessage2& aMessage,TInt aSessionId):iType(aType), iMessage(aMessage),iSessionId(aSessionId){}
                inline const TMessageType Type()const{return iType;}
                inline const RMessage2& MessageObject()const {return iMessage;}
                inline const TInt SessionId()const{return iSessionId;}
            };
        void ConstructL();
        CInternalMessageQueue(CMdnsServer& aServer);
                
    private:
        TInt iQueueLength;
        RArray<TMessageObject>  iMessageQueue;
        CMdnsServer& iServer;
        /**
            *FLOGGER debug trace member variable.
            */
            __FLOG_DECLARATION_MEMBER_MUTABLE;
        
    };


#endif /* CINTERNALMESSAGEQUEUE_H_ */
