// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// cmdnsprobemanager.h
// 
//
#ifndef CMDNSPROBEMANAGER_H_
#define CMDNSPROBEMANAGER_H_

#include <e32base.h>
#include <in_sock.h>
#include "mdnscachemgr.h"
#include "cmessagehandler.h"
#include "mmessagehandler.h"
#include "mdnsdebug.h"

const TUint32 KProbeDelay = 250;

const TUint32 KMaxFailures = 15;

const TUint16 KMaxLength = 255;

/*Maximum Length allocated for the service name part of the ServiceInstanceName
excluding the service type*/
const TUint16 KMaxNameLength = 128;
enum TConflictResolveState	
	{
	ESuccess=0,
	EConflictWithAutoReslove,
	EConflictWithoutAutoResolve,
	EFail,
	};
enum TProbeStates
    {
    EIdle,
    EStart,
    EProbeBegin,    
    EProbeFirstUnicast,
    EProbeSecondUnicast,
    EProbeMulticast,
    EProbeComplete,
    EFirstAnnouncement,//First gratuitous mDNS announcement
    ESecondAnnouncement//Second gratuitous mDNS announcement
    };

class CMDNSProbeManager : public CTimer,public MMessageHandler
	{	
	public:

	/*Probe Handler to probe for Unique Host Name*/
	static CMDNSProbeManager* NewL(MDNSCacheMgr& aCache,CMessageHandler& aMessageHandler,TBool aAutoResolveEnabled);
	/*Probe Handler to probe for Service Instance Name*/
	static CMDNSProbeManager* NewLC(MDNSCacheMgr& aCache,CMessageHandler& aMessageHandler,TBool aAutoResolveEnabled);

	~CMDNSProbeManager();

	//From MMessageHandler
	void OnPacketSendL(TInt aError);

	
	TInt StartNameProbeL(const TDesC8&aHostName,TInetAddr aAddr);
	TInt StartServiceProbeL(const TDesC8& aServiceName,const TDesC8& aTargetMachine,TUint16 aPort);

	//Called if Auto Resolve Enabled,Probe Manager would have obtained new name
	const TDesC8& GetUniqueName(); 

	private:

	void RunL();
	TInt RunError(TInt aError);

	private:

	CRdTypeA* FormAddressRecordL();
	CRdTypeSrv* FormServiceRecordL();
	
	void InsertInCache();

	TInt GenerateNonConflictingName();

	TBool DefensiveResponseL();//Get a unique name (DNS Label)
	
	void Schedule();

	void SendProbeL(TBool aUnicast); //Probe for Unique name , Create Probe and Send 
	void SendAnnouncementL();//Send out Gratitous mDNS Announcement , Create Announcement and Send

	CMDNSProbeManager (MDNSCacheMgr& aCache,CMessageHandler& aMessageHandler,TBool aAutoResolveEnabled);

	void ConstructL();


	private:

	

	TProbeStates iCurrentProbeState;
	TConflictResolveState iConflict;

	TInt iProbeCounter;

	MDNSCacheMgr& iCache;

	TBool iAutoResolveEnabled;

	CMessageHandler& iMessageHandler;

	TDnsType iType;
	RBuf8 iName;
	RBuf8 iProbeName;
	RBuf8 iProbeType;
	TInetAddr iAddr;
	TUint16 iPort;
	RBuf8 iTarget;
	/**
	    *FLOGGER debug trace member variable.
	    */
	    __FLOG_DECLARATION_MEMBER_MUTABLE;

	};

#endif /*CMDNSPROBEMANAGER_H_*/
