// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// cresponsehandler.cpp
// 
//
/**
@file
@internalTechnology
*/

#ifndef __CRESPONSEHANDLER_H__
#define __CRESPONSEHANDLER_H__

//System include 
#include <mdns/cdnsmessage.h>
#include <mdns/cdnsresourcedata.h>
//User include 
#include "cmessagehandler.h"
#include "cbasehandler.h"
#include "mdnsdebug.h"

/**
Derived From CBaseHandler
Used to process response packet read from the mdns port
*/

class CResponseHandler : public CBaseHandler
	{
	public:
		static CResponseHandler* NewL(CMessageHandler& aMessageHandler);
		~CResponseHandler();
		
		//Derived from CBaseHandler
		void HandleIncomingPacketL(CDnsMessage& aMessage ,const TSockAddr& aAddr);

	private:
	    CResponseHandler(CMessageHandler& aMessageHandler);
	    void ConstructL();
	    void HandlePacketAnswersL(CDnsResourceData* aResourceData);
	    void HandleAddrAnswersL(CDnsResourceData* aResourceData);
	 	void HandlePTRAnswersL(CDnsResourceData* aResourceData);
	 	void HandleTXTAnswersL(CDnsResourceData* aResourceData);
	 	void HandleAAAAAnswersL(CDnsResourceData* aResourceData);
	 	void HandleSRVAnswersL(CDnsResourceData* aResourceData);

	private:	
	   RArray< RBuf8> iNotifyPtrName;
	   /**
	       *FLOGGER debug trace member variable.
	       */
	       __FLOG_DECLARATION_MEMBER_MUTABLE;
	};

#endif
