// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// mdnsserver.h
// 
//
/**
@file
@internalTechnology
*/

#ifndef __MDNSSERVER_H__
#define __MDNSSERVER_H__

#include <e32base.h>
#include <es_sock.h>
#include <in_sock.h>
#include <e32property.h>
#include <mdns/dnsconstants.h>

#include "cinternalmessagequeue.h"
#include "mmessagehandler.h"
#include "mdnsdebug.h"

//class TMessageType;
class CMessageHandler;
class CMDNSProbeManager;
class CMDNSCacheConsistencyMgr;
// zeroconf messages policy - all NetworkService

const TUint zeroconfRangeCount = 1;
const TInt zeroconfRanges[zeroconfRangeCount] = 
	{
	0
	};

const TUint8 zeroconfElementsIndex[zeroconfRangeCount] = 
	{
	0
	};

const CPolicyServer::TPolicyElement zeroconfElements[] = 
	{
	{_INIT_SECURITY_POLICY_C1(ECapabilityNetworkServices), CPolicyServer::EFailClient}
	};

const CPolicyServer::TPolicy zeroconfPolicy =
	{
	CPolicyServer::EAlwaysPass,
	zeroconfRangeCount,                   
	zeroconfRanges,
	zeroconfElementsIndex,
	zeroconfElements,
	};

// The zeroconf server class

class CSocketHandler;
class CShutdownTimer;

class CMdnsServer : public CPolicyServer,public MMessageHandler
	{
public:
	static CMdnsServer* NewL();
	static CMdnsServer* NewLC();
	
	CSession2* NewSessionL(const TVersion& aVersion, const RMessage2& aMessage) const;

	TInt NewSession();
	void DropSession();
	void BeginShutdownL();
	void JoinMulticastGroupL(TInetAddr& aMulticastAddr);
	RSocket& Socket();
	CMessageHandler& MessageHandler()const;
	void NotifyClientQuery(TInt aClientHandle);
	void NotifyServicePublishL(const RBuf8& aName,TInt aError, TInt aSessionId);
	~CMdnsServer();
	TDesC8& HostName()const;
	void SetHostNameL(const TDesC8& aName);
	void SetStateHostProbing(TBool aProbing);
	void SetPublishingService(TBool aFlag);
	TBool IsHostProbing()const;
	TBool IsPublishingService() const;
	void ProcessQueuedMessage(const RMessage2& aMessage, const TMessageType aType,TInt aSessionId);
	void NotifyNewServiceL(const RArray<RBuf8>& aName);
	CInternalMessageQueue* MessageQueue();
    //From MMessageHandler
    void OnPacketSendL(TInt aError);        

	
private:
    TInt GetLocalHost ( TSockAddr& aAddr );
	CMdnsServer();
	void ConstructL();
	
	
	
private:
	RSocketServ iSockServ;
	RConnection iConnection;
	RSocket iSocket;

	CShutdownTimer* iShutdownTimer;
	CMessageHandler* iMessageHandler;
	CInternalMessageQueue* iInternalMessageQueue;
	CMDNSCacheConsistencyMgr* iCacheConsistencyMgr;
	TInt iConnectionCount;
	TInt iSessionIdCounter;
	TBool iShutdownInProgress;
	CMDNSProbeManager* iProbeManager;
	RBuf8 iHostName;
	TBool iData;
	TBool iIsHostProbing;
	TBool iIsPublishing;
	/**
	    *FLOGGER debug trace member variable.
	    */
	    __FLOG_DECLARATION_MEMBER_MUTABLE;
	};

#endif /* __MDNSSERVER_H__ */
