// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// cinternalmessagequeue.cpp
// 
//
/**
@file
@internalTechnology
*/
//User include
#include "cinternalmessagequeue.h"
#include "mdnsserver.h"
__FLOG_STMT(_LIT8(KComponent,"MDNSServer");)
/*
 * Two phase constructor
 * @param aServer reference to the server
 */
CInternalMessageQueue* CInternalMessageQueue::NewL(CMdnsServer& aServer)
    {
    CInternalMessageQueue* self = new (ELeave)CInternalMessageQueue(aServer);
    CleanupStack::PushL(self);
    self->ConstructL();
    CleanupStack::Pop();//self
    return self;
    }

//Destructor
CInternalMessageQueue:: ~CInternalMessageQueue()
    {
    __FLOG(_L8("CInternalMessageQueue::~CInternalMessageQueue - Exit"));
    __FLOG_CLOSE;
    }
 
/*
 * When this is called reads the first request form the 
 * queue and start processing.
 */
void CInternalMessageQueue::StartProcessing()
    {
    __FLOG(_L8("CInternalMessageQueue::StartProcessing - Entry"));
    if(iMessageQueue.Count() == 0)
        {
        return;
        }
    else
        {
        TMessageObject message = iMessageQueue[0];
        iServer.ProcessQueuedMessage(message.MessageObject(),message.Type(),message.SessionId());
        iMessageQueue.Remove(0);
        }
    __FLOG(_L8("CInternalMessageQueue::StartProcessing - Exit"));
    }

/*
 * @return count returns the count of messageQueue
 */

TInt CInternalMessageQueue::Count()
    {
    __FLOG(_L8("CInternalMessageQueue::Count - Entry Exit"));
    return iMessageQueue.Count();
    }
 
/*
 * Interface to append the message to the queue
 * @param aType represents the type of message.
 * @param aMessage RMessage object of the query or publish request.
 * @param aSessionId session to which request is made.
 */
void CInternalMessageQueue::AppendMessageL(TMessageType aType, const RMessage2& aMessage,TInt aSessionId )
    {
    __FLOG(_L8("CInternalMessageQueue::AppendMessageL - Entry"));
    TMessageObject messageObject(aType,aMessage,aSessionId);
    iMessageQueue.AppendL(messageObject);
    __FLOG(_L8("CInternalMessageQueue::AppendMessageL - Exit"));
    }

/*
 * Two phase constructor.
 */
void CInternalMessageQueue::ConstructL()
    {
    __FLOG_OPEN(KMDNSSubsystem, KComponent);  
    __FLOG(_L8("CInternalMessageQueue::ConstructL -Entry  Exit"));
    }

/*
 * Constructor
 * @param aServer reference to the server.
 */
CInternalMessageQueue::CInternalMessageQueue(CMdnsServer& aServer): iServer(aServer)
    {
    
    }
   
