/*
* Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/

#ifndef MDNSCACHEMGR_H_
#define MDNSCACHEMGR_H_


#include <e32cmn.h> 
#include <mdns/dnsconstants.h>


class CDnsResourceData;
class CCacheEntry;


class MDNSCacheMgr
	{
	public:

	/*Inserts a new entry into the Cache
	 @param CDnsResourceData, Resource Record
	 @param aAuthoritative indicates whether the record being inserted is authoritative
	 @param aSessionId, to indicate to which Session does the entry belong to
	 @leave KErrNoMemory if memory could not be allocated to store the copies of Key and Value*/
	virtual void UpdateCacheL(CDnsResourceData& aEntry,TBool aAuthoritative,TUint32 aSessionId)=0;
	
	/*Caters to finding varying types of records, for e.g:- find all the entries
	 that correspond to a particular service type or find the host name through the address record
	 @param aEntries List of entries that match the search constraint
	 @param	aInfo could represent any serach constraint Service Instance Type or the Host Name
	 @param aType the desired record type
	 */
	virtual TInt FindServiceL(RPointerArray <CCacheEntry> & aEntries,const TDesC8& aName,TDnsType aType)const=0;

	/*Deletes the specified entry from the Cache
	 @param aServiceInstanceName Instance Name , whose entry needs to be deleted 
	 @leave KErrNotFound if specified entry is not found
	 */
	virtual TInt DeleteEntryL(const TDesC8& aServiceInstanceName)=0;

	
	/*Flush all the entries in the cache
		 * 1. On start up
		 * 2. On Failure
		 * 3. On Topology change
		 */
	virtual void FlushCache()=0;		
	
	/*During Iteration, fetches the next stale entry ( entry whose ttl has expired - to be deleted 
	  or whose 80% ttl has expired - to be queried on the network)
	 @param aActiveCacheMgmtEnabled flag to indicate if Pro-active Cache Mgmt is to be enabled
	 */
	virtual CCacheEntry* NextStaleEntry(TBool aActiveCacheMgmtEnabled,TBool aIteratorReset)=0;
	
	/*Returns all the Authoritative Cache En tries for Announcement
	@param aEntries Output param ,containing all authoritative entries
	*/
	virtual void AuthoritativeEntriesL(RPointerArray <CCacheEntry> & aEntries)=0;
	
	/*Returns the current number of entries in Cache*/
	virtual TUint NumberOfEntries()=0;
	
	/*Dump all the entries in Cache- Debug Purposes*/
	virtual void DumpCacheL()=0;
	
	/*Virtual destructor so that the delete gets called for all the
	 Cache Implementation Interfaces*/ 	
	virtual ~MDNSCacheMgr(){}
		
	};



#endif /*MDNSCACHEMGR_H_*/
