/*
* Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/



#include "cmdnsprobemanager.h"

CMDNSProbeManager* CMDNSProbeManager::NewL(RBuf& aHostName, TInetAddr aAddr)
	{
	CMDNSProbeManager* self = CMDNSProbeManager::NewLC(aHostName,aAddr);
	CleanupStack::Pop(self);
	return self;
	}

CMDNSProbeManager* CMDNSProbeManager::NewLC(RBuf& aHostName, TInetAddr aAddr)
	{
	CMDNSProbeManager* self = new (ELeave)CMDNSProbeManager(aHostName,aAddr);
	CleanupStack::PushL(self);
	self->ConstructL();
	return self;
	}

CMDNSProbeManager::CMDNSProbeManager(RBuf& aHostName, TInetAddr aAddr):CTimer(CActive::EPriorityStandard)
	{
	
	}


CMDNSProbeManager* CMDNSProbeManager::NewL(RBuf& aServiceName,RBuf& aHostName)
	{
	CMDNSProbeManager* self = CMDNSProbeManager::NewLC(aServiceName,aHostName);
	CleanupStack::Pop(self);
	return self;
	}

CMDNSProbeManager* CMDNSProbeManager::NewLC(RBuf& aServiceName,RBuf& aHostName)
	{
	CMDNSProbeManager* self = new (ELeave)CMDNSProbeManager(aServiceName,aHostName);
	CleanupStack::PushL(self);
	self->ConstructL();
	return self;
	}

CMDNSProbeManager::CMDNSProbeManager(RBuf& aServiceName,RBuf& aHostName):CTimer(CActive::EPriorityStandard)
	{
	
	}
void CMDNSProbeManager::ConstructL()
	{
	 
	}

CMDNSProbeManager::~CMDNSProbeManager()
	{
	
	}

void CMDNSProbeManager::RunL()
	{
	switch(iCurrentProbeState)
		{
		case EIdle:
		break;
		
		case EProbeBegin:
		break;
		
		case EProbeFirstUnicast:
		break;
		
		case EProbeSecondUnicast:
		break;
		
		case EProbeMulticast:
		break;
		
		case EProbeComplete:
		break;
		
		case EFirstAnnouncement:
		break;
		
		case ESecondAnnouncement:
		break;
		
		}
	}

TInt CMDNSProbeManager::RunError(TInt aError)
	{
	return KErrNone;
	}