/*
* Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/
#ifndef CMDNSPROBEMANAGER_H_
#define CMDNSPROBEMANAGER_H_

#include <e32base.h>
#include <in_sock.h>

class CMDNSProbeManager : public CTimer
	{	
	public:

	/*Conflict can happen in 2 cases , 
	 * Case 1: When the Address Record (Type A) is inconsistent, i.e., same
	 * host name for different Ip addresses
	 * Case 2: When the Service Record (Type SRV), is conflicting, two hosts try to
	 * acquire the same service name with the same service type., and same 

	/*Case 1:To get Unique Host Name ; to handle Host name conflict, 
	 * we need the acquired host name & IPAddress*/
	static CMDNSProbeManager* NewL(RBuf& aHostName, TInetAddr aAddr);
	static CMDNSProbeManager* NewLC(RBuf& aHostName, TInetAddr aAddr);

	/*To get Unique Service Name; to handle service name conflict, 
	 * we need acquired service name & host name*/
	static CMDNSProbeManager* NewL(RBuf& aServiceName,RBuf& aHostName);
	static CMDNSProbeManager* NewLC(RBuf& aServiceName,RBuf& aHostName);

	~CMDNSProbeManager();

	private:

	void RunL();
	TInt RunError(TInt aError);

	private:

	TBool CheckForUniqueness();

	void DefensiveResponseReceived();//Get a unique name (DNS Label)

	void SendProbeL(); //Probe for Unique name , Create Probe and Send 
	void SendAnnouncementL();//Send out Gratitous mDNS Announcement , Create Announcement and Send
	void Schedule(); //Self-Complete, To be called when moved to Probe State.

	void Delay(TUint32 aDelayTime/*In Milliseconds*/); //To introduce Delay between Probes.	

	CMDNSProbeManager (RBuf& aHostName, TInetAddr aAddr);
	CMDNSProbeManager (RBuf& aServiceName,RBuf& aHostName);
	void ConstructL();

	private:

	enum TProbeStates
	{
	EIdle,
	EProbeBegin,
	EProbeFirstUnicast,
	EProbeSecondUnicast,
	EProbeMulticast,
	EProbeComplete,
	EFirstAnnouncement,//First gratuitous mDNS announcement
	ESecondAnnouncement//Second gratuitous mDNS announcement
	};

	
	TInetAddr iAddr;

	TProbeStates iCurrentProbeState;

	//MDNSCacheInterface* iCache;
	
	};

#endif /*CMDNSPROBEMANAGER_H_*/
