/*
* Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/
#ifndef CSERVICEINFO_H_
#define CSERVICEINFO_H_


#include "mdnsrecordinfo.h"
#include "mdnsdebug.h"
#include <mdns/crdtypea.h>
#include <mdns/crdtypetxt.h>
#include <mdns/crdtypesrv.h>
#include <mdns/crdtypeptr.h>

using namespace HashInfo;


class CServiceInfo : public CBase
	{
	public:

	static CServiceInfo* NewL();
	static CServiceInfo* NewLC();

	TBool IsAuthoritative()const;
	void SetAuthoritative(TBool aAuthoritative);

	const TTime& LastAccessTime()const;
	void SetAccessTime(TTime aTime);

	TUint32 SessionId()const;
	void SetSessionId(TUint32 aSessionId);

	void SetAddressRecord(CRdTypeA* aAddressRecord);
	void SetServiceRecord(CRdTypeSrv* aServiceRecord);
	void SetPtrRecord(CRdTypePtr* aPtrRecord);
	void SetTxtRecord(CRdTypeTxt* aTxtRecord);	
	
	const TTime& EntryTime(TCacheEntryType aType)const;
	const TTime& ExpiryTime(TCacheEntryType aType)const;
	
	void SetEntryTime(TCacheEntryType aType);
	void SetExpiryTime(TCacheEntryType aType);
	
	void SetKeyL(const TDesC8& aKey);
	const TDesC8& Key()const;
	
	CRdTypeA* AddressRecord()const;
	CRdTypeSrv* ServiceRecord()const;
	CRdTypePtr* PtrRecord()const;
	CRdTypeTxt* TxtRecord()const;
	
	TBool EntryExpired();
	
	TBool EntryToBeQueried();
	
	CServiceInfo* CloneL()const;
	
	//Mark the entry as expired if ttl has become zero
	TBool StaleEntry();

	~CServiceInfo();

	private:			

	void ConstructL();
	CServiceInfo();

	private:	

	CRdTypeA* iAddressRecord;
	CRdTypeSrv* iServiceRecord;
	CRdTypePtr* iPtrRecord;
	CRdTypeTxt* iTxtRecord;

	TTime iLastAccessTime;
	TBool iAuthoritative;
	TUint32 iSessionId;
	
	RBuf8 iKey;
	
	//Entries are Indexed by TCacheEntryType
	RArray <TTime> iEntryTime;
	
	//Entries are Indexed by TCacheEntryType
	RArray <TTime> iExpiryTime;

	TBool iEntryExpired;
	
	};
	
	
#endif /*CSERVICEINFO_H_*/
