/*
* Copyright (c) 2008 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/


/**
@file
@PublishedAll
*/

#ifndef __MDNSCLIENT_H__
#define __MDNSCLIENT_H__

#include <e32base.h>
#include <pnp/pnpparameterbundle.h>
#include <mdns/cmdnsquerypublishnotifier.h>
#include <mdns/cmdnsregisternotifier.h>
#include "mdnsdebug.h"
class RMdns : public RSessionBase
		{
		public:
		//These are the helper class which help in notifying the application observer
		//when the query and  notify messages are served.    
		friend class CMdnsQueryPublishNotifier;
		friend class CMdnsRegisterNotifier;
		/**
		 * Opens a new session with the multicast DNS server. Must be called before
		 * any other function may be used.
		 *
		 * @param aConnectionHandle Handle to the RConnection Object
		 * @param aSocketServerHandle Handle to the RSocketServ Object
		 * @param aObserver The callback function where the return values are commnunicated back
		 * along with the error codes.
		 * @return A CService object comprising a complete description of the service parameters.
		 * @brief Opens a new session with the zeroconf server.
		 */

		IMPORT_C TInt Open(TInt aConnectionHandle);


		/**
		 * ASynchronously lists all the available servicves of the type specified.
		 *
		 * @param aServiceType A unicode descriptor containing the type of the service you wish to resolve, including leading underscore (e.g. '_http'.)
		 * @param aProtocol The protocol the service runs over, one of TCP or UDP.
		 * @brief Asynchronously resolves a network service.
		 */

		IMPORT_C void QueryL( const RPnPParameterBundle& aQueryParams );


		/**
		 * ASynchronously resolves a network service. The results are returned using the Observer callback
		 *
		 * @param aServiceName A unicode descriptor containing the name of the service you wish to resolve.
		 * @param aServiceType A unicode descriptor containing the type of the service you wish to resolve, including leading underscore (e.g. '_http'.)
		 * @param aProtocol The protocol the service runs over, one of TCP or UDP.
		 * @brief Asynchronously resolves a network service.
		 */

		IMPORT_C void ResolveL( const RPnPParameterBundle& aResolveParams );



		/**
		 * Registers a service on the local device and will send out presence announcement on the local link
		 *
		 * @param aServiceName A unicode descriptor containing the name of the service you wish to register.
		 * @param aServiceType A unicode descriptor containing the type of the service you wish to register, including leading underscore (e.g. '_http'.)
		 * @param aProtocol The protocol the service runs over, one of TCP or UDP.
		 * @return Service registration id is returned
		 * @brief
		 */

		IMPORT_C void RegisterServiceL( const RPnPParameterBundle& aPublishParams ,TBool aIsUpdate = EFalse);



		/**
		 * Register receiving notification on the desired service instance names or types
		 *
		 * @param aServiceName A unicode descriptor containing the name of the service you wish to register for notification.
		 * @param aServiceType A unicode descriptor containing the type of the service you wish to register for notification,
		 * @param aProtocol The protocol the service runs over, one of TCP or UDP.
		 * @return Service registration id is returned
		 * @brief
		 */

		IMPORT_C void WaitForNotificationL( const RPnPParameterBundle& aNotifyParams );


		/**
		 * Cancel the ongoing request.
		 *
		 * @param aRequestType A enum specifying the type of request to be canceled.
		 * @param aServiceName A unicode descriptor containing the name of the service .
		 * @param aServiceType A unicode descriptor containing the type of the service ,
		 * @param aProtocol The protocol the service runs over, one of TCP or UDP.
		 * @return
		 * @brief
		 */

		IMPORT_C TInt Cancel( const RPnPParameterBundle& aCancelParams );




		/**
		 *
		 * De-register the service from the device and send out absence announcement on the local-link
		 *
		 * @param aServiceRegId A integer id that uniquely identifies a registered service.
		 * @return Success or failure of the close request.
		 * @brief
		 */

		IMPORT_C TInt Close();

		/**
		Default Constructor
		*/
		IMPORT_C RMdns::RMdns();


		private:
        /*
         * Based on the buffer size set by the query request Recieve Message is called
         * which return the set of records got from the query.
         * @param  aData reference to a buffer to which the records should be set.
         */
		void RecieveMessage(TDes8& aData);
		/*
		 * These is an asynchroonous request called internally by the WaitForNotification request.
		 * @param aData contains the list of new ptr records recieved on WaitForNotification request.
		 * @param aStatus used to complete asynchronous request.
		 */
		void RecieveNotifyMessageL(TDes8& aData,TRequestStatus& aStatus);
		private:
		/*
		 * Query and publish request will be notifies to this object.
		 */
		CMdnsQueryPublishNotifier* iEventNotifier;
		/*
		 * Register for a paritcular record will be notified to this object.
		 */
		CMdnsRegisterNotifier*     iRegisterNotifier;
		/*
		 *Buffer used to store the data in the RPnPParameter bundle and send it across to 
		 *the server.
		 */
		HBufC8* iBuffer;
		/* 
		 * Keeps the count of entries requested for notification.
		 */
		TInt iNotifierCount;
		/*
		 * Pointer to the descriptor iBuffer.
		 */
		TPtr8 iBufPointer;
		/**
        FLOGGER debug trace member variable.
        */
		__FLOG_DECLARATION_MEMBER_MUTABLE;
		};


#endif /* __MDNSCLIENT_H__ */
