/*
* Copyright (c) 2008 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/


/**
@file
@internalTechnology
*/

#ifndef __CADVERTIZEHANDLER_H__
#define __CADVERTIZEHANDLER_H__

//User include
#include "cmessagehandler.h"
#include <mdns/cdnsmessage.h>
#include "cbasehandler.h"
#include "cmdnsprobemanager.h"
#include "mmessagehandler.h"
#include "mdnsdebug.h"

class CAdvertizeHandler : public CBaseHandler ,public MMessageHandler
	{
	public:
		static CAdvertizeHandler* NewL(CMessageHandler& aMessageHandler,TBool aAutoResolveEnabled  = ETrue);
		~CAdvertizeHandler();
		void HandleIncomingPacketL(CDnsMessage& aMessage);
		void AdvertizePacketL(const RPointerArray<CDnsResourceData> aData, TInt aSessionId, TBool aIsUpdate);
		void SetAutoResolve(TBool aFlag);
		//From MMessageHandler
		void OnPacketSendL(TInt aError);
	private:
		CAdvertizeHandler(CMessageHandler& aMessageHandler,TBool aAutoResolveEnabled);
		void ConstructL();
		void RunL();
		TInt RunError(TInt aError);
		void Schedule();
		TInt GenerateNonConflictingName();
	    TBool DefensiveResponseL();
	    void SendAnnouncementL();
	    void InsertInCache();
	    void SendProbeL(TBool aUnicast);
	    void ChangeDomainL(TDesC8& aName);
	private:
	    RBuf8 iName;
		TBool iAutoResolveEnabled;
		TProbeStates iCurrentProbeState;
		TConflictResolveState iConflict;
		TInt iProbeCounter;
		RPointerArray<CDnsResourceData> iData;
		RBuf8 iProbeName;
		RBuf8 iProbeType;
		TInt  iSessionId;
		/**
		FLOGGER debug trace member variable.
		*/
		__FLOG_DECLARATION_MEMBER_MUTABLE;
	};



#endif //__CADVERTIZEHANDLER_H__
