// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// csendmessagequeue.h
// 
//
/**
@file
@internalTechnology
*/

#ifndef __CSENDMESSAGEQUEUE_H__
#define __CSENDMESSAGEQUEUE_H__

//system include 
#include <e32base.h>
#include <es_sock.h>
#include <e32math.h>
#include <mdns/cdnsmessage.h>
#include <mdns/cdnsmessagecomposerparser.h>

//user include 

#include "msockethandlerobserver.h"
#include "csockethandler.h"
#include "mmessagehandler.h"
#include "mdnsdebug.h"

class MMessageHandler;
class CSendMessageData
	{
	public:
	   	static CSendMessageData* NewL(CDnsMessage* aDnsMessage, TBool aUnicast,TSockAddr aAddr, MMessageHandler& aCallback);
	   	const CDnsMessage& GetDnsMessage()const;
	   	const TSockAddr& GetSockAddress()const;
	   	const TBool& IsUnicast()const;
	   	~CSendMessageData();
		MMessageHandler& Callback();
	private:
		void ConstructL();
		CSendMessageData(CDnsMessage* aDnsMessage,TBool aUnicast,TSockAddr aAddr, MMessageHandler& aCallback);
	   	
	private:   	
		CDnsMessage* iMessage;
		TBool iUnicast;
		TSockAddr iSockAddr	;
		MMessageHandler& iCallback;
		/**
        *FLOGGER debug trace member variable.
        */
        __FLOG_DECLARATION_MEMBER_MUTABLE;
	};
	
	
class CSendMessageQueue : public CTimer, public MSocketHandlerObserver 
	{
	public:
		static CSendMessageQueue* NewL(RSocket& aSocket);
		~CSendMessageQueue();
		virtual void OnCompletionL(TDesC8& aData, const TSockAddr& aAddr, TInt aLength);
		virtual void OnError(TInt aError);
		void RunL();
		void DoCancel();
		void QueueDnsMessageL(const CSendMessageData& aMessageData);
	
	private:
	    CSendMessageQueue();
	    void ConstructL(RSocket& aSocket);
	    void NextTransmitTime(TTime aTime);
	    void StartTransmit();
	    CSendMessageData* NextDnsMessageL();
	    TBool MessageReady();
	    
	private:
		CSendMessageData* iSendMessageData;
		CSocketHandler* iSendSocket;
		RPointerArray<CSendMessageData> iMessageQueue;
		TInt64 iRandomSeed;
		TTime iNextTransmit;
		TBool iIsSocketActive;
		RBuf8 iOutput;
		/**
		    *FLOGGER debug trace member variable.
		    */
		    __FLOG_DECLARATION_MEMBER_MUTABLE;
	};

#endif
