// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// cbasehandler.cpp
// 
//
/**
@file
@internalTechnology
*/

//System include 
#include <mdns/ccacheentry.h>
#include <mdns/cdnsmessage.h>

//User Include 
#include "cbasehandler.h"
__FLOG_STMT(_LIT8(KComponent,"MDNSServer");)
/*
 * Two phase constructor
 * @param aDnsMessage pointer to DnsMessage which should be sent to the network.
 * @param  aTransactionId transaction id
 * @param  aTime time at which this message should be scheduled.
 * @Param  aSockAddr address to which this should be sent.
 */
COutStandingQuery* COutStandingQuery::NewL(CDnsMessage* aDnsMessage,TInt aTransactionId,TTime aTime, TSockAddr aAddr)
	{
	COutStandingQuery* self = new (ELeave) COutStandingQuery(aDnsMessage,aTransactionId, aTime, aAddr);	
	CleanupStack::PushL(self);
	self->ConstructL();
	CleanupStack::Pop();
	return self;
	}

/*
 * Destructor
 */
COutStandingQuery::~COutStandingQuery()
	{
	__FLOG(_L8("COutStandingQuery::~COutStandingQuery- Entry"));
	delete iDnsMessage;
	__FLOG(_L8("COutStandingQuery::~COutStandingQuery- Exit"));
	__FLOG_CLOSE;
	}

/*
 * @return iReviewTime returns the time data is added to queue.
 */
 TTime COutStandingQuery::GetAddTime() const
	{
	__FLOG(_L8("COutStandingQuery::GetAddTime- Entry"));
	__FLOG(_L8("COutStandingQuery::GetAddTime- Exit"));
	return iReviewTime;
	}
	
 /*
  *Sets the clienhandle (session) which request for the query.
  *@param aHandle Sessionid of the client. 
  */
void COutStandingQuery::SetClientHandle(TInt aHandle)
	{
	__FLOG(_L8("COutStandingQuery::SetClientHandle- Entry"));
	iClientHandle = aHandle;
	__FLOG(_L8("COutStandingQuery::SetClientHandle- Exit"));
	}
	
/*
 * @return returns ths transaction id
 */
TInt COutStandingQuery::TransactionId()const 
	{
	__FLOG(_L8("COutStandingQuery::TransactionId- Entry"));
	return iTransactionID;	
	}

/*
 * @return returns the socket address
 */
TSockAddr COutStandingQuery::SocketAddress()const
	{
	__FLOG(_L8("COutStandingQuery::SocketAddress- Entry"));
	return iSockAddress;	
	}

/*
 * @return iDnsMessage returns the reference to dns message.
 */
CDnsMessage& COutStandingQuery::DnsMessage()const
	{
	__FLOG(_L8("COutStandingQuery::DnsMessage- Entry"));
	return *iDnsMessage;	
	}

/*
 * Two phase constructor
 */
void COutStandingQuery::ConstructL()
	{
	__FLOG_OPEN(KMDNSSubsystem, KComponent);
	}

/*
 * Constructor
 * @param aDnsMessage pointer to DnsMessage which should be sent to the network.
 * @param  aTransactionId transaction id
 * @param  aTime time at which this message should be scheduled.
 * @Param  aSockAddr address to which this should be sent.
 */
COutStandingQuery::COutStandingQuery(CDnsMessage* aDnsMessage,TInt aTransactionId,TTime aTime, TSockAddr aAddr): iDnsMessage(aDnsMessage) , iTransactionID(aTransactionId) ,iReviewTime(aTime), iSockAddress(aAddr)
	{
	iClientHandle = 0;
	}

/*
 * @return iClientHandle clinethandle to which request is handled.
 */
TInt  COutStandingQuery::ClientHandle() const
	{
	__FLOG(_L8("COutStandingQuery::ClientHandle- Entry"));
	return iClientHandle;	
	}

/**
Two phase constructor
@param aMessageHandler refernce to messagehandler
@return void
*/
CBaseHandler* CBaseHandler::NewL(CMessageHandler& aMessageHandler)
	{
	CBaseHandler* self = new (ELeave)CBaseHandler(aMessageHandler);
	CleanupStack::PushL(self);
	self->ConstructL();
	CleanupStack::Pop();
	return self;	
	}
/**
Destructor
*/	
CBaseHandler::~CBaseHandler()
	{
	__FLOG(_L8("CBaseHandler::~CBaseHandler - Entry"));
	Cancel();
	iOutStandingQueryArray.ResetAndDestroy();
	iOutStandingQueryArray.Close();
	__FLOG(_L8("CBaseHandler::~CBaseHandler - Exit"));
	__FLOG_CLOSE;
	}

/**
Constructor
*/	 
CBaseHandler::CBaseHandler(CMessageHandler& aMessageHandler): CTimer(EPriorityStandard),iMessageHandler(aMessageHandler)
	{
	
	CActiveScheduler::Add(this);	
	
	}
/**
Two phase constructor
*/
void CBaseHandler::ConstructL()
	{
	__FLOG_OPEN(KMDNSSubsystem, KComponent);
	__FLOG(_L8("CBaseHandler::Open - Entry"));
	CTimer::ConstructL();
	__FLOG(_L8("CBaseHandler::Open - Exit"));
	}
/**
Constant function returns a reference to messagehandler
*/
CMessageHandler& CBaseHandler::MessageHandler()const
	{
	__FLOG(_L8("CBaseHandler::MessageHandler - Entry Exit"));
	return iMessageHandler;	
	}
	
/**
Handles any incoming packet
@param aMessage packet recieved form mdns port
*/
void CBaseHandler::HandleIncomingPacketL(CDnsMessage& /*aMessage*/, const TSockAddr& /*aAddr*/)
	{
	__FLOG(_L8("CBaseHandler::HandleIncomingPacketL - Entry"));
	//Nothing  To do ...........	
	__FLOG(_L8("CBaseHandler::HandleIncomingPacketL - Exit"));
	}

/*
 * Wait for 120ms after the query is sent to the network.
 * After 120ms asynchronous request gets complete and will hit this runl
 * server will be notified with the same and it will take care of sending the 
 * response back to client.
 */
void CBaseHandler::RunL()
	{
	__FLOG(_L8("CBaseHandler::RunL - Entry"));
	COutStandingQuery* query = iOutStandingQueryArray[0];
	if(0 != query->ClientHandle())
		{
		MessageHandler().NotifyClientQuery(query->ClientHandle());	
		}
	else
		{
		IsLastTruncated = EFalse;	
		}	
	iOutStandingQueryArray.Remove(0);
	if(iOutStandingQueryArray.Count())
		{
		SetActive();
		const TTime outTime = iOutStandingQueryArray[0]->GetAddTime();
		At(outTime);
		}
	__FLOG(_L8("CBaseHandler::Open - Exit"));
	delete query;	
	}
	
/*
 * Nothing to do.
 */	
void CBaseHandler::DoCancel()
	{
	__FLOG(_L8("CBaseHandler::RunL - Exit"));	
	}



				
