/*
* Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/
#ifndef CMDNSCACHEMAP_H_
#define CMDNSCACHEMAP_H_

#include <e32hashtab.h>
#include "cserviceinfo.h"


class CMDNSCacheMap : public CBase
	{
	public:

	static CMDNSCacheMap* NewL(TUint aMaxCacheEntries);
	static CMDNSCacheMap* NewLC(TUint aMaxCacheEntries);
 

	void UpdateL(const TDesC8& aName, CServiceInfo* aEntry);
	CServiceInfo* Find(const TDesC8& aServiceInstanceName);
	void FindEntries(const TDesC8& aName,RPointerArray <const CServiceInfo> & aEntries);
	/*?? Do I require this method??*/void AuthoritativeRecordsL(RPointerArray <const CServiceInfo> & aEntries);
	TInt DeleteL(const TDesC8& aServiceInstanceName);
	void DeleteAllEntries();
	
	TUint32 NumberOfEntries();
	
	void DumpCacheL();	

	//Used to trace the entire Cache, return number of cache activities
	CServiceInfo* NextStaleEntry(TBool aActiveCacheMgmtEnabled,TBool aIteratorReset);
	
	~CMDNSCacheMap();


	private:

	/*What to do if the number of entries in Hash Table exceed 200??
	 * Delete a  entries, based on Least Recently Used
	 * Need to keep track of unused entries/ least recently used
	 * in the cache ; to delete them and make room for new entries*/		

	//Algorithm to keep track of the Least Recently Used Records
	TBool DeleteLeastRecentlyUsed();
	
	
	void ConstructL();	
	CMDNSCacheMap(TUint aMaxCacheEntries);

	private:

	RHashMap<TPtrC8,CServiceInfo*> iCacheEntries;
	
	THashMapIter<TPtrC8,CServiceInfo*> iterate;
	
	TUint iMaxCacheEntries;

	/**
    FLOGGER debug trace member variable.
	 */
	__FLOG_DECLARATION_MEMBER;  

	};
	

#endif /*CMDNSCACHEMAP_H_*/
