// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// cmdnsquerypublishnotifier.h
// 
//
/**
@file
@internalTechnology
*/

#ifndef __CMDNSQUERYPUBLISHNOTIFIER_H__
#define __CMDNSQUERYPUBLISHNOTIFIER_H__
#include <e32base.h>
#include "cmdnsserverconstants.h"
#include <mdns/dnsconstants.h>
#include "mdnsdebug.h"
class MPnPObserver;

class RMdns;
class CMdnsQueryPublishNotifier :public CActive
	{
	public :
		static CMdnsQueryPublishNotifier* NewL(RMdns& aMdns);
		~CMdnsQueryPublishNotifier();
		void RunL();
		void DoCancel();
		TPckg<TInt>& BufferLength();
		void SetEventNotifierActive();
		TRequestStatus& EventNotifierStatus();
		void SetPnpObserver(MPnPObserver* aObserver);
		TMdnsServerMessages State() const ;
		void SetState(TMdnsServerMessages aState);
		
	private:
		CMdnsQueryPublishNotifier(RMdns& aMdns);
		void ConstructL();
	private:
	    TInt iBufferLength;
	    TPckg<TInt> iPckgLength;
		RMdns& iMdns;
		MPnPObserver* iObserver;	
		TMdnsServerMessages iState;
		TInt iPublishResult;
		TBuf8<KMaxDNSNameLength> iPublishName;
		/**
        FLOGGER debug trace member variable.
        */
		__FLOG_DECLARATION_MEMBER_MUTABLE;
	};
	
#endif	
