// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// cmdnsquerypublishnotifier.cpp
// 
//

/**
@file
@internalTechnology
*/
//User include 
#include "cmdnsquerypublishnotifier.h"
#include "cmdnsclient.h"

//System include
#include <pnp/mpnpobserver.h>
#include <mdns/mdnsparamset.h>
__FLOG_STMT(_LIT8(KComponent,"CMdnsQueryPublishNotifier");)
/*
 * Two phase constructor.
 * @param aMdns a refernce to the mdns client .
 * @return returns  the instance .
 */
CMdnsQueryPublishNotifier* CMdnsQueryPublishNotifier::NewL(RMdns& aMdns)
	{
	CMdnsQueryPublishNotifier* self = new (ELeave)CMdnsQueryPublishNotifier(aMdns);
	return self;
	}

/*
 * Destructor 
 */
CMdnsQueryPublishNotifier::~CMdnsQueryPublishNotifier()
	{
	__FLOG(_L8("CMdnsQueryPublishNotifier::~CMdnsQueryPublishNotifier - Entry"));
	iObserver = NULL;
	__FLOG(_L8("CMdnsQueryPublishNotifier::~CMdnsQueryPublishNotifier - Exit"));
	__FLOG_CLOSE;
	}
/*
 * :)Function gets hit whenever a query or publish request gets completed.
 * On completeion iBufferlength contains the no of bytes to be allocated to read 
 * the response.
 */
void CMdnsQueryPublishNotifier::RunL()
	{
	__FLOG(_L8("CMdnsQueryPublishNotifier::RunL - Entry"));
	if(iStatus.Int() == KErrNone )
	    {
	    HBufC8* data = HBufC8::NewL(iBufferLength);
	    CleanupStack::PushL(data);
	    TPtr8 dataPointer(data->Des());
	    RPnPParameterBundle responseBundle;
	    responseBundle.CreateL();
	    switch (iState)
	    {
	    case EMdnsServerQueryMessages :
	        {
	        iMdns.RecieveMessage(dataPointer);
            responseBundle.Load(dataPointer);
            iObserver->OnPnPEventL(responseBundle);
            
            
             break;
	        }
	    case EMndsServerPublishMessages:
	        {
	        iMdns.RecieveMessage(dataPointer);
            responseBundle.Load(dataPointer);
            iObserver->OnPnPEventL(responseBundle);
            break;	        
	        
	        }
	    }
	    responseBundle.Close();
	    CleanupStack::PopAndDestroy();//data
	    }
	else
	    {
	    iObserver->OnPnPError(iStatus.Int());
	    }
	__FLOG(_L8("CMdnsQueryPublishNotifier::RunL - Exit"));
	}


void CMdnsQueryPublishNotifier::DoCancel()
	{
	__FLOG(_L8("CMdnsQueryPublishNotifier::DoCancel - Entry"));
	iObserver = NULL;
	__FLOG(_L8("CMdnsQueryPublishNotifier::DoCancel - Exit"));
	}

/*
 * Constructor
 * @param reference to RMdns 
 */
CMdnsQueryPublishNotifier::CMdnsQueryPublishNotifier(RMdns& aMdns):CActive(EPriorityStandard),iMdns(aMdns),iPckgLength(iBufferLength)
	{
	__FLOG_OPEN(KMDNSSubsystem, KComponent);
	__FLOG(_L8("CMdnsQueryPublishNotifier::CMdnsQueryPublishNotifier - Entry"));
	CActiveScheduler::Add(this);
	__FLOG(_L8("CMdnsQueryPublishNotifier::CMdnsQueryPublishNotifier - Exit"));
	}

/*
 * return reference to iBufferLength object .\\
 * Same will be used to set the size of the buffer client can expect on completion of 
 * query and publish.
 * @return iBufferlength areference to iBufferLength object
 */
TPckg<TInt>& CMdnsQueryPublishNotifier::BufferLength()
	{
	__FLOG(_L8("CMdnsQueryPublishNotifier::BufferLength - Entry"));
	return iPckgLength;
	__FLOG(_L8("CMdnsQueryPublishNotifier::BufferLength - Exit"));
	}

/*
 * Cancel the asynchoronous request if it is already active.
 * Calls SetActive and sets the status to KRequestPending.
 */
void CMdnsQueryPublishNotifier::SetEventNotifierActive()
	{
	__FLOG(_L8("CMdnsQueryPublishNotifier::SetEventNotifierActive - Entry"));
	if(IsActive())
	    {
	    Cancel();
	    }
	SetActive();
	iStatus = KRequestPending;
	__FLOG(_L8("CMdnsQueryPublishNotifier::SetEventNotifierActive - Exit"));
	}

/*
 * Returns the refernce to iStatus of the active object
 * @return iStatus reference to status of the active object.
 */
TRequestStatus& CMdnsQueryPublishNotifier::EventNotifierStatus()
	{
	__FLOG(_L8("CMdnsQueryPublishNotifier::EventNotifierStatus - Entry"));
	return iStatus;
	__FLOG(_L8("CMdnsQueryPublishNotifier::EventNotifierStatus - Exit"));
	}

/*
 * Function to keep a refernce to the observer of the client.
 * @param aObserver An observer to the client.
 */

void CMdnsQueryPublishNotifier::SetPnpObserver(MPnPObserver* aObserver)
	{
	__FLOG(_L8("CMdnsQueryPublishNotifier::SetPnpObserver - Entry"));
	iObserver = aObserver;
	__FLOG(_L8("CMdnsQueryPublishNotifier::SetPnpObserver - Exit"));
	}
/*
 * Set the state to either query or publish based on the request.
 * @param aState either query or publish.
 */
void CMdnsQueryPublishNotifier::SetState(TMdnsServerMessages aState)
    {
    __FLOG(_L8("CMdnsQueryPublishNotifier::SetState - Entry"));
    iState = aState;
    __FLOG(_L8("CMdnsQueryPublishNotifier::SetState - Exit"));
    }

/*
 * Returns the service notifier is  in 
 * @return iState returns the state. 
 */
TMdnsServerMessages CMdnsQueryPublishNotifier::State() const 
    {
    __FLOG(_L8("CMdnsQueryPublishNotifier::State - Entry"));
    return iState;
    __FLOG(_L8("CMdnsQueryPublishNotifier::State - Exit"));
    }
