// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// cmdnsregisternotifier.cpp
// 
//

/**
@file
@internalTechnology
*/

//System include
#include <mdns/mdnsparamset.h>
#include <pnp/mpnpobserver.h>

//User include
#include "cmdnsregisternotifier.h"
#include "cmdnsclient.h"
__FLOG_STMT(_LIT8(KComponent,"CMdnsRegisterNotifier");)
/*
 * Two phase constructor
 * @param aMdns reference to RMdns client object
 */
CMdnsRegisterNotifier* CMdnsRegisterNotifier::NewL(RMdns& aMdns)
    {
    CMdnsRegisterNotifier* self = new (ELeave) CMdnsRegisterNotifier(aMdns);
    CleanupStack::PushL(self);
    self->ConstructL();
    CleanupStack::Pop();
    return self ;
    }
/*
 * Destructor
 */
CMdnsRegisterNotifier::~CMdnsRegisterNotifier()
    {
    __FLOG(_L8("CMdnsRegisterNotifier:: - Entry"));
    //Cancel any pending asynchronous request.
    Cancel();
    delete iNotifyRcvdMessage;
    iNotifyRcvdMessage = NULL;
    __FLOG(_L8("CMdnsRegisterNotifier:: - Exit"));
    __FLOG_CLOSE;
    }

/*
 * Constructor
 * @param aMdns reference to mdns object.
 */
CMdnsRegisterNotifier::CMdnsRegisterNotifier(RMdns& aMdns):CActive(EPriorityStandard),iMdns(aMdns),iPtrNotifyRcvdMessage(NULL,0,0)
    {
    
    }

/*
 * Two phase constructor
 * Construct a buffer to recieve a new record from the network.
 * and start listening to it.
 */
void CMdnsRegisterNotifier::ConstructL()
    {
    __FLOG_OPEN(KMDNSSubsystem, KComponent);
    __FLOG(_L8("CMdnsRegisterNotifier::ConstructL - Entry"));
    CActiveScheduler::Add(this);
    iNotifyRcvdMessage = HBufC8::NewL(KMaxDNSNameLength);
    iPtrNotifyRcvdMessage.Set(iNotifyRcvdMessage->Des());
    Start();
    __FLOG(_L8("CMdnsRegisterNotifier::ConstructL - Exit"));
    }
/*
 * Constructs a bundle and notifies the same to the client.
 *  
 */
void CMdnsRegisterNotifier::RunL()
    {
    __FLOG(_L8("CMdnsRegisterNotifier::RunL - Entry"));
    if(iObserver != NULL)
        {
        if(iStatus.Int() == KErrNone)
            {
            RPnPParameterBundle pnpBundle;
            pnpBundle.CreateL();
            pnpBundle.Load(iPtrNotifyRcvdMessage);
            iObserver->OnPnPEventL(pnpBundle);
            pnpBundle.Close();
            }
        else 
            {
            iObserver->OnPnPError(iStatus.Int());
            }
        }
    Start();
    __FLOG(_L8("CMdnsRegisterNotifier::RunL - Exit"));
    }

/*
 * Clears the buffer .
 */
void CMdnsRegisterNotifier::DoCancel()
    {
    __FLOG(_L8("CMdnsRegisterNotifier::DoCancel - Entry"));
    TRequestStatus * status = &iStatus;
    User::RequestComplete(status,KErrCancel);
    delete iNotifyRcvdMessage;
    iNotifyRcvdMessage = NULL;
    __FLOG(_L8("CMdnsRegisterNotifier::DoCancel - Exit"));
    }

/*
 * Returns the error to activeschedluler as the RunL is not expected to leave.
 * @param aError error with which RunL leaves.
 * @return aError returns the error back to activescheduler .
 */
TInt CMdnsRegisterNotifier::RunError(TInt aError)
    {
    __FLOG(_L8("CMdnsRegisterNotifier::RunError - Entry"));
    return aError;
    __FLOG(_L8("CMdnsRegisterNotifier::RunError - Exit"));
    }

/*
 * Start as Asynchoronous request and wait for this to be completed by the server .
 * Will be called internally whenever a client requests for the notification.
 * 
 */
void CMdnsRegisterNotifier::Start()
    {
    __FLOG(_L8("CMdnsRegisterNotifier::Start - Entry"));
    iStatus = KRequestPending;
    iMdns.RecieveNotifyMessageL(iPtrNotifyRcvdMessage,iStatus);
    SetActive();
    __FLOG(_L8("CMdnsRegisterNotifier::Start - Exit"));
    }

/*
 * Set the observer
 * @param aObserver a pointer to the observer sent by the client along with the bundle.
 */
void CMdnsRegisterNotifier::SetPnpObserver(MPnPObserver* aObserver)
    {
    __FLOG(_L8("CMdnsRegisterNotifier::SetPnpObserver - Entry"));
    iObserver = aObserver;
    __FLOG(_L8("CMdnsRegisterNotifier::SetPnpObserver - Exit"));
    }
