// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// ecom_impl.cpp
// 
//

#include <ecom/implementationproxy.h>
#include "mdnsparamsextfactory.h"
#include "mdnsparamset.h"
#include "cmdnsservicediscoveryimpl.h"
#include "cmdnspnpservicepublisherimpl.h"

  
const TImplementationProxy ImplementationTable[] =
	{
	IMPLEMENTATION_PROXY_ENTRY(KMDnsParamsFactoryUid, CMDnsParamsExtFactory::NewL),
	IMPLEMENTATION_PROXY_ENTRY(KUPnPDiscoveryUid, CMDnsServiceDiscoveryImpl::NewL),
	IMPLEMENTATION_PROXY_ENTRY(KMDnsPublisherUid, CMDnsServicePublisherImpl::NewL)
	};


EXPORT_C const TImplementationProxy* ImplementationGroupProxy(TInt& aTableCount)
    {
    aTableCount = sizeof(ImplementationTable) / sizeof(TImplementationProxy);
    return ImplementationTable;
    }
