/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/


#ifndef __CDNSMESSAGECOMPOSERPARSER_H__
#define __CDNSMESSAGECOMPOSERPARSER_H__

#include <e32base.h>
#include <comms-infras/commsdebugutility.h>
#include <es_sock.H>
#include <mdns/cdnsmessage.h>
#include <mdns/cdnsquestion.h>
#include <mdns/crdtypeptr.h>
#include <mdns/crdtypea.h>
#include <mdns/crdtypesrv.h>
#include <mdns/crdtypetxt.h>
#include <mdns/dnsconstants.h>

class CDnsPacket;
class CDnsMsgBuf;

//Main class which mDNS Responder will be making use to evoke compose and parse operations
class CDnsMessageComposerParser: public CBase
	{
public:
	IMPORT_C static CDnsMessageComposerParser* NewL();
	IMPORT_C void CreateMessageL(RBuf8& aMessageBuffer, const CDnsMessage& aMessage );
	IMPORT_C CDnsMessage* ParseMessageL(const TDesC8& aBuffer);
	~CDnsMessageComposerParser();
	void ConstructL();
	
private:	
    CDnsMessageComposerParser();
	CDnsResourceData* GetResourceRecordsL();
	void AppendResourceRecordsL( CDnsResourceData* aResourceRecord );
	TUint16 GetLength( const CDnsMessage& aMessage )const;
	
private:	
	RBuf8 iBuf;
	CDnsPacket* iPacket;
	CDnsMsgBuf* iMsgBuf;
	__FLOG_DECLARATION_MEMBER;
    };

#endif 	//__CDNSMESSAGECOMPOSERPARSER_H__