/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/



#ifndef __CDNSPACKET_H__
#define __CDNSPACKET_H__

#include <e32base.h>
#include <es_sock.h>
#include <in_sock.h>

#include "tdnsheader.h"

#define __OOB(aIndex,aDataLength)     {if(aIndex >= aDataLength)  User::Leave(KErrCorrupt);}
	
_LIT8(KDot,".");

class CDnsPacket : public CBase
	{
public:
    ~CDnsPacket();
	static CDnsPacket* NewL(const TDes8& aPacketPtr);
	TUint8  GetCharL();
	TUint16 GetInt16L();
	TUint32 GetInt32L();
	const TDnsHeader& GetHeaderL();
	void GetDomainNameL(TDes8& aName);
	void GetRdDomainNameL(TDes8& aDomainName,TUint aLength);
	void GetStringL(TDes8& aString, TUint16 aLength);			
	
private:
	void ConstructL();
	CDnsPacket(const TDes8& aPacketPtr);
	void GetStringAtIndexL(TDes8& aLabel, TUint aOffset);
	void GetDomainNameAtIndexL(TDes8& aDomainName, TUint aOffset);
	
private:
	TDnsHeader iHeader;	
	const TUint8* iPtr;
	TUint iIndex;
	TUint iDataLength;
	TUint iMaxLength;
	};

#endif  //__CDNSPACKET_H__
