/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/




#ifndef __CRDTYPEPTR_H__
#define __CRDTYPEPTR_H__

#include <e32base.h>
#include <mdns/cdnsresourcedata.h>
#include <mdns/dnsconstants.h>


/*
The compression scheme allows a domain name in a message to be
represented as either:

   - a sequence of labels ending in a zero octet

   - a pointer

   - a sequence of labels ending with a pointer
*/


class CRdTypePtr : public CDnsResourceData
    {
public:
	IMPORT_C ~CRdTypePtr();
    IMPORT_C static CRdTypePtr* NewL();

	IMPORT_C const TDesC8& DomainName()const;
	IMPORT_C void SetDomainNameL(const TDesC8& aDomainName);
	
	void ConstructL(const TDesC8& aDomainName);
	IMPORT_C TUint16 Size()const;
	
private : 
    CRdTypePtr();
    
private : 
	RBuf8 iDomainName;
    };

#endif //__CRDTYPEPTR_H__