/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/


#ifndef __CSTRINGPARSER_H__
#define __CSTRINGPARSER_H__

// String parser class to parse a string incremently
class CStringParser : public CBase
    {
public:
	static CStringParser* NewL  ( const TDesC8& aBuffer );

	virtual ~CStringParser ();	

	TBool GetNextCharacter ( TChar& aChar );
	TBool GetCurrentCharacter ( TChar& aChar );
	TBool ParseTill ( TPtrC8& aWord, TChar aEndChar );
	void ParseTill ( TPtrC8& aWord, const TDesC8& aCharSet );
	
	TBool SkipLength ( TInt aLen );

	void GetRemainder ( TPtrC8& aBuffer );
protected:
	CStringParser ( const TDesC8& aBuffer );
	
private:
	void IncrementCurrentPos ();
	
private:
	const TDesC8& iBuffer;
	TInt iCurrentPos;
    };

#endif // __CSTRINGPARSER_H__