/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/


#include "cdnsresourcedata.h"
#include "crdtypeptr.h"
#include "crdtypea.h"
#include "crdtypesrv.h"
#include "crdtypetxt.h"


CDnsResourceData::CDnsResourceData():CDnsSection()    
	{	
	}

EXPORT_C CDnsResourceData::~CDnsResourceData()
	{
	}


EXPORT_C TBool CDnsResourceData::IsFlushBitSet()const
	{
	if(iClass & KFlushBit)
		return ETrue;
	else
		return EFalse;
	}

EXPORT_C void CDnsResourceData::SetFlushBit(TBool aFlushBit)
	{
	if(aFlushBit)
		iClass |= KFlushBit;
	else
		iClass &= ~KFlushBit;
	}

EXPORT_C TUint16 CDnsResourceData::RdLength()const
	{
	return iRdLength;
	}

EXPORT_C void CDnsResourceData::SetRdLength(TUint16 aRdLength)
	{
	iRdLength = aRdLength;
	}

EXPORT_C TUint32 CDnsResourceData::Ttl()const
	{
	return iTtl;
	}

EXPORT_C void CDnsResourceData::SetTtl(TUint32 aTtl)
	{
	iTtl = aTtl;
	}


//Creates a new copy of this object. Leaves if a memory allocation fails
EXPORT_C CDnsResourceData* CDnsResourceData::CloneL()const
	{
	CDnsResourceData* recordData = NULL;

	switch(Type())
		{
		case EDnsType_A: // A record 
			{
			const CRdTypeA* addrRecord = static_cast<const CRdTypeA*>(this);
			CRdTypeA* rrAddrRecord = CRdTypeA::NewL();
			CleanupStack::PushL(rrAddrRecord);

			rrAddrRecord->SetNameL(addrRecord->Name());
			rrAddrRecord->SetType(addrRecord->Type());
			rrAddrRecord->SetClass(addrRecord->Class());
			rrAddrRecord->SetTtl(addrRecord->Ttl());
			rrAddrRecord->SetRdLength(addrRecord->RdLength());							
			rrAddrRecord->SetAddr(addrRecord->Address());
			
			CleanupStack::Pop(rrAddrRecord);
			recordData = rrAddrRecord;
			}
		    break;

		case EDnsType_PTR: // ptr record
			{
			const CRdTypePtr* ptrRecord = static_cast<const CRdTypePtr*>(this);
			CRdTypePtr* rrPtrRecord = CRdTypePtr::NewL();
			CleanupStack::PushL(rrPtrRecord);
			
			rrPtrRecord->SetNameL(ptrRecord->Name());
			rrPtrRecord->SetType(ptrRecord->Type());
			rrPtrRecord->SetClass(ptrRecord->Class());
			rrPtrRecord->SetTtl(ptrRecord->Ttl());
			rrPtrRecord->SetRdLength(ptrRecord->RdLength());						
			rrPtrRecord->SetDomainNameL(ptrRecord->DomainName());
            
			CleanupStack::Pop(rrPtrRecord);
			recordData = rrPtrRecord;
			}
		    break;

		case EDnsType_SRV: // srv record
			{
			const CRdTypeSrv* srvRecord = static_cast<const CRdTypeSrv*>(this);
			CRdTypeSrv* rrSrvRecord = CRdTypeSrv::NewL();
			CleanupStack::PushL(rrSrvRecord);
			
			rrSrvRecord->SetNameL(srvRecord->Name());
			rrSrvRecord->SetClass(srvRecord->Class());
			rrSrvRecord->SetType(srvRecord->Type());
			rrSrvRecord->SetTtl(srvRecord->Ttl());
			rrSrvRecord->SetRdLength(srvRecord->RdLength());
			rrSrvRecord->SetPriority(srvRecord->Priority());
			rrSrvRecord->SetWeight(srvRecord->Weight());
			rrSrvRecord->SetPort(srvRecord->Port());							
			rrSrvRecord->SetTargetL(srvRecord->Target());
			
			CleanupStack::Pop(rrSrvRecord);
			recordData = rrSrvRecord;
			}
			break;

		case EDnsType_TXT: // Txt record
			{
			const CRdTypeTxt* txtRecord = static_cast<const CRdTypeTxt*>(this);
			CRdTypeTxt* rrTxtRecord = CRdTypeTxt::NewL();
			CleanupStack::PushL(rrTxtRecord);
			
			rrTxtRecord->SetNameL(txtRecord->Name());
			rrTxtRecord->SetType(txtRecord->Type());
			rrTxtRecord->SetClass(txtRecord->Class());
			rrTxtRecord->SetTtl(txtRecord->Ttl());
			rrTxtRecord->SetRdLength(txtRecord->RdLength());
										
			const RArray<RBuf8>& txtList = txtRecord->Text();
			TInt count = txtList.Count();
			for(TInt j=0; j<count; j++)
				{
				RBuf8 txtBuf;
				txtBuf.CreateL(txtList[j]);
				rrTxtRecord->AppendTextDataL(txtBuf);
				}
			CleanupStack::Pop(rrTxtRecord);
			recordData = rrTxtRecord;
			}
		    break;  	     		
		}
	return recordData;
	}

TUint16 CDnsResourceData::Size()const
	{
	return 0; 
	}


