/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/


#include "crdtypesrv.h"


CRdTypeSrv::CRdTypeSrv():CDnsResourceData()          
	{
	}

EXPORT_C CRdTypeSrv* CRdTypeSrv::NewL()
	{
	return (new(ELeave)CRdTypeSrv());
	}

EXPORT_C CRdTypeSrv::~CRdTypeSrv()
	{
	iTarget.Close();
	}

EXPORT_C TUint16  CRdTypeSrv::Priority()const
	{
	return iPrio;
	}

EXPORT_C void CRdTypeSrv::SetPriority(TUint16 aPriority)
	{
	iPrio = aPriority;
	}

EXPORT_C TUint16 CRdTypeSrv::Weight() const
	{
	return iWeight;
	}

EXPORT_C void CRdTypeSrv::SetWeight(TUint16 aWeight)
	{
	iWeight = aWeight;
	}

EXPORT_C TUint16 CRdTypeSrv::Port()const
	{
	return iPort;
	}
EXPORT_C void CRdTypeSrv::SetPort(TUint16 aPort)
	{
	iPort = aPort;
	}

EXPORT_C const TDesC8& CRdTypeSrv::Target() const
	{
	return iTarget;
	}

EXPORT_C void CRdTypeSrv::SetTargetL(const TDesC8& aTarget)
	{
	iTarget.Close();
	iTarget.CreateL(aTarget);
	}

EXPORT_C TUint16 CRdTypeSrv::Size()const
	{
	TUint16 count = 0;
	count += iName.Size();
	count += 2; // 2 bytes = descriptor length+ 0 length octet at the end
	count += sizeof(iType);
	count += sizeof(iClass);
	count += sizeof(iTtl);
	count += sizeof(iRdLength);
	count += sizeof(iPrio);
	count += sizeof(iWeight);
	count += sizeof(iPort);
	count += iTarget.Size();
	count += 2; // 2 bytes = descriptor length+ 0 length octet at the end
	return count;
	}

