// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// cmdnsconsistencymgr.cpp
// 
//

#ifndef CMDNSCACHECONSISTENCYMGR_H_
#define CMDNSCACHECONSISTENCYMGR_H_

#include <e32base.h>
#include <mdns/mdnscachemgr.h>
#include <mdns/ccacheentry.h>
#include <mdns/cdnsmessage.h>
#include "mmessagehandler.h"
#include "mdnsdebug.h"

const TUint KDefaultCheckInterval = 10;//*60; // TODO:Change to 60 seconds for practical purposes
//#include "cmessagehandler.h"
class CMessageHandler;
class CMDNSCacheConsistencyMgr : public CActive,public MMessageHandler
	{
	public:
	
	static CMDNSCacheConsistencyMgr* NewL(TBool aActiveCacheMgmtEnabled,CMessageHandler& aMessageHandler);
	static CMDNSCacheConsistencyMgr* NewLC(TBool aActiveCacheMgmtEnabled,CMessageHandler& aMessageHandler);
	
	//From MMessageHandler
	void OnPacketSendL(TInt aError);
	
	void Start(TUint aWalkInterval = KDefaultCheckInterval);
	
	void Stop();
		
	~CMDNSCacheConsistencyMgr();
	void DoCancel();
	
	private:
									
	void RunL();
	TInt RunError(TInt aError);
				
	void IterateCacheL();	
	void DeleteEntry(CCacheEntry* aEntry);
	void Query(CCacheEntry* aEntry);
	const TDesC8& GetHostName(CCacheEntry* aEntry);
	const TDesC8& GetServiceName(CCacheEntry* aEntry);
	
	void Delay(TRequestStatus& status);
					
	private:
	
	CMDNSCacheConsistencyMgr(TBool aActiveCacheMgmtEnabled,CMessageHandler& aMessageHandler);
	void ConstructL();

	private:
	
	//MDNSCacheMgr& iCache;
	
	TBool iActiveCacheMgmtEnabled;
	
	CMessageHandler& iMessageHandler;	
	
	TUint iWalkInterval;
	
	RTimer iTimer;
	
	/**
	    FLOGGER debug trace member variable.
	 */
	__FLOG_DECLARATION_MEMBER_MUTABLE;
	
	};


#endif /*CMDNSCACHECONSISTENCYMGR_H_*/
