/*
 Copyright (c) 2007 Nokia Corporation and/or its subsidiary(-ies).
 All rights reserved.
 This component and the accompanying materials are made available
 under the terms of "Eclipse Public License v1.0"
 which accompanies this distribution, and is available
 at the URL "http://www.eclipse.org/legal/epl-v10.html".

 Initial Contributors:
 Nokia Corporation - initial contribution.

 Contributors:

 Description: A simple shutdown timer definition. 

*/

#ifndef __SHUTDOWNTIMER_H__
#define __SHUTDOWNTIMER_H__

#include <e32base.h>
#include "mdnsdebug.h"
// shutdown delay, 5 minutes.
const TInt KShutdownDelay = 5 * 60 * 1000000;

class CMdnsServer;

class CShutdownTimer : public CTimer
	{
public:
	static CShutdownTimer* NewL(CMdnsServer& aServer);
	static CShutdownTimer* NewLC(CMdnsServer& aServer);
	
	void Start();
	void RunL();
	TInt RunError(TInt aError);
	~CShutdownTimer();
private:
	CShutdownTimer(CMdnsServer& aServer);
	
private:
	CMdnsServer& iServer;
	/**
    FLOGGER debug trace member variable.
    */
    __FLOG_DECLARATION_MEMBER_MUTABLE;
	};

#endif /* __SHUTDOWNTIMER_H__ */
