/*
* Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/

#include <e32test.h>
#include <f32file.h>
#include <httpclientserver/mhttpauthenticationcallback.h>
#include <httpclientserver/mhttptransactioncallback.h>
#include <httpclientserver/mhttpdatasupplier.h>
#include <httpclientserver/framework/logging.h>
#include <httpclientserver/mhttpsessioneventcallback.h>

class CHttpExampleUtils;
class CHttpServerTransactionBase;

class MTransactionNotify
    {
    public:
    virtual void OnTransactionCompleted ( CHttpServerTransactionBase* iTrans ) =0;      
    };
class CHttpServer : public CBase,
                    public MHTTPTransactionCreationCallback,
                    public MTransactionNotify,
                    public MHTTPSessionEventCallback
    {
public:
    virtual ~CHttpServer();
    static CHttpServer* NewLC();
    static CHttpServer* NewL();
    //void StartClientL();
    void SetupClientL ();
    //virtual void StartHttpServer();
    
    void ProcessSelectionL ( TInt aSelection );
    
    TInt GetLocalHost ( TSockAddr& aAddr );
    
    TDesC8& GetIPAddress();
    
    void StartConnectionL(TInt aIapId);
    
protected:
    CHttpServer();
    void ConstructL();
private:

    enum TMenuItems
        {
        EStart = 1,
        EStop,
        EExit,
        };

    void ResetTimeElapsed();
    void DisplayTimeElapsed();
    //
    void SetHeaderL(RHTTPHeaders aHeaders, TInt aHdrField, const TDesC8& aHdrValue);
    void SetDefaults(TDes& aURL, TDes& aProxy, TDes& aHook, TDes& aSessionId);
    
    // From MHTTPTransactionCreationCallback
    RHTTPTransaction NewTransactionL ( const TUriC8& aUri, RStringF aMethod );
    
    void OnTransactionCompleted ( CHttpServerTransactionBase* iTrans );
    
    // From MHTTPSessionEventCallback
    virtual void MHFSessionRunL ( const THTTPSessionEvent& aEvent );
    virtual TInt MHFSessionRunError ( TInt aError, const THTTPSessionEvent& aEvent );
    
    void CleanupTransactions ();
    
private:
    TTime iLastTimeStamp;
    TInt iDataChunkCount;
    
    RHTTPClientServerSession     iSess;
    
    RFs iFileServ;
    TBool iManualPost;
    //CHttpExampleUtils* iUtils;
    RArray <CHttpServerTransactionBase*> iTransactions;
    RFile iLogFile;
    
    RBuf8 iIPAddr;
    
    // Connection
    RConnection iConnection;
    
    // SocketServer
    RSocketServ iSocketServ;
    
    __FLOG_DECLARATION_MEMBER;
    };

class CHttpServerTransactionBase : public CBase, public MHTTPTransactionCallback
    {
public:
    virtual ~CHttpServerTransactionBase ();
    RHTTPTransaction Transaction ()
        {
        return iTransaction;    
        }

protected:
    CHttpServerTransactionBase ( MTransactionNotify& aNotify, /*CHttpExampleUtils& aUtils,*/ RFs& aFileServ );
    
    void SetHeaderL(RStringPool& aStringPool, RHTTPHeaders aHeaders, TInt aHdrField, const TDesC8& aHdrValue);
    
    void ConstructL ( RHTTPClientServerSession& aSession, const TUriC8& aUri, RStringF aMethod );
    protected:
    //
    // methods from MHTTPTransactionCallback
    //
    virtual void MHFRunL(RHTTPTransaction aTransaction, const THTTPEvent& aEvent);
    virtual TInt MHFRunError(TInt aError, RHTTPTransaction aTransaction, const THTTPEvent& aEvent);
    
protected:
    MTransactionNotify& iNotify;
    RFs&                iFileServ;
    //CHttpExampleUtils&  iUtils; // not owned                
    RFile               iFile;
    RHTTPTransaction    iTransaction;
    
    __FLOG_DECLARATION_MEMBER;  
    };
    
class CHttpDataTransmitter : public CHttpServerTransactionBase, public MHTTPDataSupplier
    {
public: 
    static CHttpDataTransmitter* NewL ( MTransactionNotify& aNotify, /*CHttpExampleUtils& aUtils,*/ RFs& aFileServ, RHTTPClientServerSession& aSession, const TUriC8& aUri, RStringF aMethod );
    
    TInt OpenFile( const TDesC8& aHttpPath );
private:
    //
    // methods from MHTTPTransactionCallback
    //
    virtual void MHFRunL(RHTTPTransaction aTransaction, const THTTPEvent& aEvent);
    virtual TInt MHFRunError(TInt aError, RHTTPTransaction aTransaction, const THTTPEvent& aEvent);
    
    // From MHTTPDataSupplier
    virtual TBool GetNextDataPart(TPtrC8& aDataPart);
    virtual void ReleaseData();
    virtual TInt OverallDataSize();
    virtual TInt Reset();
    
private:    
    CHttpDataTransmitter (MTransactionNotify& aNotify,/*CHttpExampleUtils& aUtils,*/ RFs& aFileServ);
    
private:
    TBuf8 <4096>    iData;
    TInt            iDataToSend;
    TBuf8<32>       iContentType;
    TBool           iTransSubmitted;
    
    __FLOG_DECLARATION_MEMBER;
    };

